/*
 * Decompiled with CFR 0.152.
 */
package cn.starrys.tool.mail;

import cn.starrys.tool.mail.entity.Mail;
import cn.starrys.tool.mail.entity.MailAddressee;
import cn.starrys.tool.mail.entity.MailProps;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailTools {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailTools.class);
    @NotNull
    private final MailProps mailProps;

    public MailTools(@NotNull String host, @NotNull Integer port, @NotNull String from, @NotNull String password) {
        this(host, port, from, password, null);
    }

    public MailTools(@NotNull String host, @NotNull Integer port, @NotNull String from, @NotNull String password, String nickname) {
        this(host, port, from, password, nickname, true);
    }

    public MailTools(@NotNull String host, @NotNull Integer port, @NotNull String from, @NotNull String password, String nickname, boolean ssl) {
        this(host, port, from, password, nickname, ssl, false);
    }

    public MailTools(@NotNull String host, @NotNull Integer port, @NotNull String from, @NotNull String password, String nickname, boolean ssl, boolean debug) {
        this(new MailProps(host, port, from, password, nickname, ssl, debug, StandardCharsets.UTF_8, true));
    }

    public MailTools(@NotNull MailProps mailProps) {
        this.mailProps = mailProps;
    }

    public Session getSession(@NotNull MailProps.Protocols protocol) {
        Properties properties = new Properties();
        if (MailProps.Protocols.SMTP == protocol) {
            properties.setProperty("mail.transport.protocol", protocol.get());
        } else {
            properties.setProperty("mail.store.protocol", protocol.get());
        }
        properties.setProperty("mail.host", this.mailProps.getHost());
        properties.setProperty(String.format("mail.%s.port", new Object[]{protocol}), this.mailProps.getPort().toString());
        properties.setProperty("mail.from", this.mailProps.getFrom());
        properties.setProperty("mail.password", this.mailProps.getPassword());
        Optional.ofNullable(this.mailProps.getNickname()).ifPresent(name -> properties.setProperty("mail.user", (String)name));
        if (this.mailProps.isSsl()) {
            properties.setProperty(String.format("mail.%s.ssl.enable", new Object[]{protocol}), "true");
            properties.setProperty(String.format("mail.%s.ssl.socketFactory", new Object[]{protocol}), "javax.net.ssl.SSLSocketFactory");
        }
        if (this.mailProps.isAuth()) {
            properties.setProperty(String.format("mail.%s.auth", new Object[]{protocol}), "true");
        }
        if (this.mailProps.isDebug()) {
            properties.setProperty("mail.debug", "true");
        }
        return this.getSession(properties);
    }

    private Session getSession(Properties props) {
        if (this.mailProps.isAuth()) {
            return Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailTools.this.mailProps.getFrom(), MailTools.this.mailProps.getPassword());
                }
            });
        }
        return Session.getDefaultInstance((Properties)props);
    }

    public MimeMessage createMimeMessage(Session session, @NotNull Mail mail) {
        try {
            List<MailAddressee> bcc;
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(this.mailProps.getFrom(), this.mailProps.getNickname(), this.mailProps.getCharset().name()));
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])this.createInternetAddresses(mail.getTo()));
            List<MailAddressee> cc = mail.getCc();
            if (cc != null) {
                mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])this.createInternetAddresses(cc));
            }
            if ((bcc = mail.getBcc()) != null) {
                mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])this.createInternetAddresses(bcc));
            }
            mimeMessage.setSubject(mail.getSubject(), this.mailProps.getCharset().name());
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            if (mail.getType() == Mail.Type.TEXT) {
                mimeBodyPart.setText(mail.getBody(), this.mailProps.getCharset().name());
            } else {
                mimeBodyPart.setContent((Object)mail.getBody(), "text/html;charset=" + this.mailProps.getCharset().name());
            }
            MimeMultipart mimeMultipart = new MimeMultipart("mixed");
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            List<File> attachments = mail.getAttachments();
            if (attachments != null) {
                for (File attachment : attachments) {
                    MimeBodyPart fileBodyPart = new MimeBodyPart();
                    fileBodyPart.attachFile(attachment);
                    mimeMultipart.addBodyPart((BodyPart)fileBodyPart);
                }
            }
            mimeMessage.setContent((Multipart)mimeMultipart);
            mimeMessage.setSentDate(new Date());
            mimeMessage.saveChanges();
            return mimeMessage;
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u4e0d\u652f\u6301 \u201c{}\u201d \u6b64\u7f16\u7801", (Object)this.mailProps.getCharset(), (Object)e);
        }
        catch (MessagingException e) {
            log.error("\u521b\u5efa\u90ae\u4ef6\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u6dfb\u52a0\u9644\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
        }
        return null;
    }

    private InternetAddress @NotNull [] createInternetAddresses(@NotNull List<MailAddressee> addresseeList) throws UnsupportedEncodingException {
        InternetAddress[] internetAddresses = new InternetAddress[addresseeList.size()];
        for (int i = 0; i < internetAddresses.length; ++i) {
            MailAddressee mailAddressee = addresseeList.get(i);
            internetAddresses[i] = new InternetAddress(mailAddressee.getAddressee(), mailAddressee.getNickname(), this.mailProps.getCharset().name());
        }
        return internetAddresses;
    }

    public boolean send(String addressee, String subject, String body) {
        return this.send(addressee, null, subject, body);
    }

    public boolean send(String addressee, String nickname, String subject, String body) {
        return this.send(addressee, nickname, subject, body, null);
    }

    public boolean send(String addressee, String nickname, String subject, String body, List<File> attachments) {
        ArrayList<MailAddressee> to = new ArrayList<MailAddressee>();
        to.add(new MailAddressee(addressee, nickname));
        return this.send(to, subject, body, attachments);
    }

    public boolean send(List<MailAddressee> to, String subject, String body, List<File> attachments) {
        return this.send(new Mail(to, subject, body, attachments, Mail.Type.HTML, null, null));
    }

    public boolean send(Mail mail) {
        return this.send(this.createMimeMessage(this.getSession(MailProps.Protocols.SMTP), mail));
    }

    public boolean send(MimeMessage msg) {
        if (this.mailProps.isAuth()) {
            try {
                Transport.send((Message)msg);
            }
            catch (MessagingException e) {
                log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01", (Throwable)e);
                return false;
            }
        }
        Session session = msg.getSession();
        try (Transport transport = session.getTransport();){
            transport.connect(this.mailProps.getHost(), this.mailProps.getPort().intValue(), this.mailProps.getFrom(), this.mailProps.getPassword());
            transport.sendMessage((Message)msg, msg.getAllRecipients());
        }
        catch (MessagingException e) {
            log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
        return true;
    }
}

