/*
 * Decompiled with CFR 0.152.
 */
package cn.starrys.mail;

import cn.starrys.mail.entity.Mail;
import cn.starrys.mail.entity.MailAddressee;
import cn.starrys.mail.entity.MailProps;
import cn.starrys.mail.entity.MailProtocol;
import cn.starrys.mail.entity.MailType;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailTools {
    private static final Logger log = LoggerFactory.getLogger(MailTools.class);
    @NotNull
    private final String host;
    @NotNull
    private final Integer port;
    @NotNull
    private final String from;
    @NotNull
    private final String password;
    private final String nickname;
    private final boolean ssl;
    private final boolean debug;
    private final Charset charset;
    private final boolean auth;

    public MailTools(@NotNull String host, @NotNull Integer port, @NotNull String from, @NotNull String password) {
        this(host, port, from, password, null);
    }

    public MailTools(@NotNull String host, @NotNull Integer port, @NotNull String from, @NotNull String password, String nickname) {
        this(host, port, from, password, nickname, true);
    }

    public MailTools(@NotNull String host, @NotNull Integer port, @NotNull String from, @NotNull String password, String nickname, boolean ssl) {
        this(host, port, from, password, nickname, ssl, false, StandardCharsets.UTF_8);
    }

    public MailTools(@NotNull String host, @NotNull Integer port, @NotNull String from, @NotNull String password, String nickname, boolean ssl, boolean debug, Charset charset) {
        this(host, port, from, password, nickname, ssl, debug, charset, true);
    }

    public MailTools(@NotNull String host, @NotNull Integer port, @NotNull String from, @NotNull String password, String nickname, boolean ssl, boolean debug, Charset charset, boolean auth) {
        this(new MailProps(host, port, from, password, nickname, ssl, debug, charset, auth));
    }

    public MailTools(@NotNull MailProps props) {
        this.host = props.getHost();
        this.port = props.getPort();
        this.from = props.getFrom();
        this.password = props.getPassword();
        this.nickname = props.getNickname();
        this.ssl = props.isSsl();
        this.debug = props.isDebug();
        this.charset = props.getCharset();
        this.auth = props.isAuth();
    }

    public Session getSession(@NotNull MailProtocol protocol) {
        Properties properties = new Properties();
        if (MailProtocol.SMTP == protocol) {
            properties.setProperty("mail.transport.protocol", protocol.get());
        } else {
            properties.setProperty("mail.store.protocol", protocol.get());
        }
        properties.setProperty("mail.host", this.host);
        properties.setProperty(String.format("mail.%s.port", new Object[]{protocol}), this.port.toString());
        properties.setProperty("mail.from", this.from);
        properties.setProperty("mail.password", this.password);
        Optional.ofNullable(this.nickname).ifPresent(name -> properties.setProperty("mail.user", (String)name));
        if (this.ssl) {
            properties.setProperty(String.format("mail.%s.ssl.enable", new Object[]{protocol}), "true");
            properties.setProperty(String.format("mail.%s.ssl.socketFactory", new Object[]{protocol}), "javax.net.ssl.SSLSocketFactory");
        }
        if (this.auth) {
            properties.setProperty(String.format("mail.%s.auth", new Object[]{protocol}), "true");
        }
        if (this.debug) {
            properties.setProperty("mail.debug", "true");
        }
        return this.getSession(properties);
    }

    private Session getSession(Properties props) {
        if (this.auth) {
            return Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailTools.this.from, MailTools.this.password);
                }
            });
        }
        return Session.getDefaultInstance((Properties)props);
    }

    public MimeMessage createMimeMessage(Session session, @NotNull Mail mail) {
        try {
            List<MailAddressee> mailBcc;
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(this.from, this.nickname, this.charset.name()));
            List<MailAddressee> mailTo = mail.getTo();
            InternetAddress[] to = new InternetAddress[mailTo.size()];
            for (int i = 0; i < to.length; ++i) {
                MailAddressee addressee = mailTo.get(i);
                to[i] = new InternetAddress(addressee.getAddressee(), addressee.getNickname(), this.charset.name());
            }
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])to);
            List<MailAddressee> mailCc = mail.getCc();
            if (mailCc != null) {
                InternetAddress[] cc = new InternetAddress[mailCc.size()];
                for (int i = 0; i < cc.length; ++i) {
                    MailAddressee addressee = mailCc.get(i);
                    cc[i] = new InternetAddress(addressee.getAddressee(), addressee.getNickname(), this.charset.name());
                }
                mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])cc);
            }
            if ((mailBcc = mail.getBcc()) != null) {
                InternetAddress[] bcc = new InternetAddress[mailBcc.size()];
                for (int i = 0; i < bcc.length; ++i) {
                    MailAddressee addressee = mailBcc.get(i);
                    bcc[i] = new InternetAddress(addressee.getAddressee(), addressee.getNickname(), this.charset.name());
                }
                mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
            }
            mimeMessage.setSubject(mail.getSubject(), this.charset.name());
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            if (mail.getMailType() == MailType.TEXT) {
                mimeBodyPart.setText(mail.getBody(), this.charset.name());
            } else {
                mimeBodyPart.setContent((Object)mail.getBody(), "text/html;charset=" + this.charset.name());
            }
            MimeMultipart mimeMultipart = new MimeMultipart("mixed");
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            List<File> attachments = mail.getAttachments();
            if (attachments != null) {
                for (File attachment : attachments) {
                    MimeBodyPart fileBodyPart = new MimeBodyPart();
                    fileBodyPart.attachFile(attachment);
                    mimeMultipart.addBodyPart((BodyPart)fileBodyPart);
                }
            }
            mimeMessage.setContent((Multipart)mimeMultipart);
            mimeMessage.setSentDate(new Date());
            mimeMessage.saveChanges();
            return mimeMessage;
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u4e0d\u652f\u6301 \u201c{}\u201d \u6b64\u7f16\u7801", (Object)this.charset, (Object)e);
        }
        catch (MessagingException e) {
            log.error("\u521b\u5efa\u90ae\u4ef6\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u6dfb\u52a0\u9644\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
        }
        return null;
    }

    public boolean send(String addressee, String subject, String body) {
        return this.send(addressee, null, subject, body);
    }

    public boolean send(String addressee, String nickname, String subject, String body) {
        return this.send(addressee, nickname, subject, body, null);
    }

    public boolean send(String addressee, String nickname, String subject, String body, List<File> attachments) {
        ArrayList<MailAddressee> to = new ArrayList<MailAddressee>();
        to.add(new MailAddressee(addressee, nickname));
        return this.send(to, subject, body, attachments);
    }

    public boolean send(List<MailAddressee> to, String subject, String body, List<File> attachments) {
        return this.send(to, subject, body, attachments, MailType.HTML);
    }

    public boolean send(List<MailAddressee> to, String subject, String body, List<File> attachments, MailType mailType) {
        return this.send(to, subject, body, attachments, mailType, null, null);
    }

    public boolean send(List<MailAddressee> to, String subject, String body, List<File> attachments, MailType mailType, List<MailAddressee> cc, List<MailAddressee> bcc) {
        return this.send(new Mail(to, subject, body, attachments, mailType, cc, bcc));
    }

    public boolean send(Mail mail) {
        return this.send(this.createMimeMessage(this.getSession(MailProtocol.SMTP), mail));
    }

    public boolean send(MimeMessage msg) {
        if (this.auth) {
            try {
                Transport.send((Message)msg);
            }
            catch (MessagingException e) {
                log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01", (Throwable)e);
                return false;
            }
        }
        Session session = msg.getSession();
        try (Transport transport = session.getTransport();){
            transport.connect(this.host, this.port.intValue(), this.from, this.password);
            transport.sendMessage((Message)msg, msg.getAllRecipients());
        }
        catch (MessagingException e) {
            log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
        return true;
    }
}

