/*
 * Decompiled with CFR 0.152.
 */
package cn.starrys.tool.mail;

import cn.starrys.tool.mail.entity.Mail;
import cn.starrys.tool.mail.entity.MailAddressee;
import cn.starrys.tool.mail.entity.MailProps;
import cn.starrys.tool.mail.entity.MailProtocols;
import cn.starrys.tool.mail.entity.MailType;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B;\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0004\u0010\u000fB3\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0010B)\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0011J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020%J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(J8\u0010)\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0!2\b\u0010,\u001a\u0004\u0018\u00010\u00072\b\u0010-\u001a\u0004\u0018\u00010\u00072\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010!J<\u0010)\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010,\u001a\u0004\u0018\u00010\u00072\b\u0010-\u001a\u0004\u0018\u00010\u00072\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010!J,\u0010)\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010,\u001a\u0004\u0018\u00010\u00072\b\u0010-\u001a\u0004\u0018\u00010\u0007J\"\u0010)\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u00072\b\u0010,\u001a\u0004\u0018\u00010\u00072\b\u0010-\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00061"}, d2={"Lcn/starrys/tool/mail/MailTools;", "", "mailProps", "Lcn/starrys/tool/mail/entity/MailProps;", "<init>", "(Lcn/starrys/tool/mail/entity/MailProps;)V", "host", "", "port", "", "from", "password", "nickname", "ssl", "", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "smtpSession", "Ljakarta/mail/Session;", "getSmtpSession", "()Ljakarta/mail/Session;", "smtpSession$delegate", "Lkotlin/Lazy;", "getSession", "protocol", "Lcn/starrys/tool/mail/entity/MailProtocols;", "cia", "", "Ljakarta/mail/internet/InternetAddress;", "addresseeList", "", "Lcn/starrys/tool/mail/entity/MailAddressee;", "(Ljava/util/List;)[Ljakarta/mail/internet/InternetAddress;", "createMimeMessage", "Ljakarta/mail/internet/MimeMessage;", "session", "mail", "Lcn/starrys/tool/mail/entity/Mail;", "send", "msg", "to", "subject", "body", "attachments", "Ljava/io/File;", "addressee", "starry-mail"})
@SourceDebugExtension(value={"SMAP\nMailTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MailTools.kt\ncn/starrys/tool/mail/MailTools\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,283:1\n1#2:284\n1557#3:285\n1628#3,3:286\n1863#3,2:293\n37#4:289\n36#4,3:290\n*S KotlinDebug\n*F\n+ 1 MailTools.kt\ncn/starrys/tool/mail/MailTools\n*L\n140#1:285\n140#1:286,3\n181#1:293,2\n146#1:289\n146#1:290,3\n*E\n"})
public final class MailTools {
    @NotNull
    private final MailProps mailProps;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy smtpSession$delegate;

    public MailTools(@NotNull MailProps mailProps) {
        Intrinsics.checkNotNullParameter((Object)mailProps, (String)"mailProps");
        this.mailProps = mailProps;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.smtpSession$delegate = LazyKt.lazy(() -> MailTools.smtpSession_delegate$lambda$0(this));
    }

    private final Session getSmtpSession() {
        Lazy lazy = this.smtpSession$delegate;
        return (Session)lazy.getValue();
    }

    public MailTools(@NotNull String host, int port, @NotNull String from, @NotNull String password, @Nullable String nickname, boolean ssl) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this(new MailProps(host, port, from, password, nickname, ssl, false, Charsets.UTF_8, true));
    }

    public MailTools(@NotNull String host, int port, @NotNull String from, @NotNull String password, @Nullable String nickname) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this(host, port, from, password, nickname, true);
    }

    public MailTools(@NotNull String host, int port, @NotNull String from, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this(host, port, from, password, null);
    }

    @NotNull
    public final Session getSession(@NotNull MailProtocols protocol) {
        Properties properties;
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Properties $this$getSession_u24lambda_u242 = properties = new Properties();
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[protocol.ordinal()]) {
            case 1: {
                Object object = $this$getSession_u24lambda_u242.put("mail.store.protocol", (Object)protocol);
                break;
            }
            case 2: {
                $this$getSession_u24lambda_u242.put("mail.transport.protocol", (Object)protocol);
                Object object = $this$getSession_u24lambda_u242.put("mail.store.protocol", (Object)protocol);
                break;
            }
            case 3: {
                Object object = $this$getSession_u24lambda_u242.put("mail.transport.protocol", (Object)protocol);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$getSession_u24lambda_u242.put("mail.host", this.mailProps.getHost());
        $this$getSession_u24lambda_u242.put("mail." + protocol + ".port", (Object)this.mailProps.getPort());
        $this$getSession_u24lambda_u242.put("mail.from", this.mailProps.getFrom());
        $this$getSession_u24lambda_u242.put("mail.password", this.mailProps.getPassword());
        String string = this.mailProps.getNickname();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$getSession_u24lambda_u242.put("mail.user", it);
        }
        if (this.mailProps.getSsl()) {
            $this$getSession_u24lambda_u242.put("mail." + protocol + ".ssl.enable", "true");
            $this$getSession_u24lambda_u242.put("mail." + protocol + ".ssl.socketFactory", "javax.net.ssl.SSLSocketFactory");
        }
        if (this.mailProps.getAuth()) {
            $this$getSession_u24lambda_u242.put("mail." + protocol + ".auth", "true");
        }
        if (this.mailProps.getDebug()) {
            $this$getSession_u24lambda_u242.put("mail.debug", "true");
        }
        Properties properties2 = properties;
        if (this.mailProps.getAuth()) {
            Session session = Session.getInstance((Properties)properties2, (Authenticator)new Authenticator(this){
                final /* synthetic */ MailTools this$0;
                {
                    this.this$0 = $receiver;
                }

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailTools.access$getMailProps$p(this.this$0).getFrom(), MailTools.access$getMailProps$p(this.this$0).getPassword());
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getInstance(...)");
            return session;
        }
        Session session = Session.getInstance((Properties)properties2);
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getInstance(...)");
        return session;
    }

    /*
     * WARNING - void declaration
     */
    private final InternetAddress[] cia(List<MailAddressee> addresseeList) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = addresseeList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void mailAddressee;
            MailAddressee mailAddressee2 = (MailAddressee)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new InternetAddress(mailAddressee.getAddressee(), mailAddressee.getNickname(), this.mailProps.getCharset().name()));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new InternetAddress[0]);
    }

    @NotNull
    public final MimeMessage createMimeMessage(@NotNull Session session, @NotNull Mail mail) {
        List<MailAddressee> it;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)mail, (String)"mail");
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.mailProps.getFrom(), this.mailProps.getNickname(), this.mailProps.getCharset().name()));
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])this.cia(mail.getTo()));
        List<MailAddressee> list = mail.getCc();
        if (list != null) {
            it = list;
            boolean bl = false;
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])this.cia(it));
        }
        List<MailAddressee> list2 = mail.getBcc();
        if (list2 != null) {
            it = list2;
            boolean bl = false;
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])this.cia(it));
        }
        mimeMessage.setSubject(mail.getSubject(), this.mailProps.getCharset().name());
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        switch (WhenMappings.$EnumSwitchMapping$1[mail.getType().ordinal()]) {
            case 1: {
                mimeBodyPart.setText(mail.getBody(), this.mailProps.getCharset().name());
                break;
            }
            case 2: {
                mimeBodyPart.setContent((Object)mail.getBody(), "text/html;charset=" + this.mailProps.getCharset().name());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        MimeMultipart mimeMultipart = new MimeMultipart("mixed");
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        List<File> list3 = mail.getAttachments();
        if (list3 != null) {
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MimeBodyPart mimeBodyPart2;
                File attachment = (File)element$iv;
                boolean bl = false;
                MimeBodyPart $this$createMimeMessage_u24lambda_u247_u24lambda_u246 = mimeBodyPart2 = new MimeBodyPart();
                boolean bl2 = false;
                $this$createMimeMessage_u24lambda_u247_u24lambda_u246.attachFile(attachment);
                mimeMultipart.addBodyPart((BodyPart)$this$createMimeMessage_u24lambda_u247_u24lambda_u246);
            }
        }
        mimeMessage.setContent((Multipart)mimeMultipart);
        mimeMessage.setSentDate(new Date());
        mimeMessage.saveChanges();
        return mimeMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean send(@NotNull MimeMessage msg) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            if (this.mailProps.getAuth()) {
                Transport.send((Message)((Message)msg));
            } else {
                AutoCloseable autoCloseable = (AutoCloseable)msg.getSession().getTransport();
                Throwable throwable = null;
                try {
                    Transport it = (Transport)autoCloseable;
                    boolean bl2 = false;
                    it.connect(this.mailProps.getHost(), this.mailProps.getPort(), this.mailProps.getFrom(), this.mailProps.getPassword());
                    it.sendMessage((Message)msg, msg.getAllRecipients());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            bl = true;
        }
        catch (MessagingException err) {
            this.logger.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01", (Throwable)err);
            bl = false;
        }
        return bl;
    }

    public final boolean send(@NotNull Mail mail) {
        Intrinsics.checkNotNullParameter((Object)mail, (String)"mail");
        return this.send(this.createMimeMessage(this.getSmtpSession(), mail));
    }

    public final boolean send(@NotNull List<MailAddressee> to, @Nullable String subject, @Nullable String body, @Nullable List<? extends File> attachments) {
        Intrinsics.checkNotNullParameter(to, (String)"to");
        return this.send(new Mail(to, null, null, MailType.HTML, subject, body, attachments));
    }

    public final boolean send(@NotNull String addressee, @Nullable String nickname, @Nullable String subject, @Nullable String body, @Nullable List<? extends File> attachments) {
        Intrinsics.checkNotNullParameter((Object)addressee, (String)"addressee");
        ArrayList<MailAddressee> to = new ArrayList<MailAddressee>();
        to.add(new MailAddressee(addressee, nickname));
        return this.send((List<MailAddressee>)to, subject, body, attachments);
    }

    public final boolean send(@NotNull String addressee, @Nullable String nickname, @Nullable String subject, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)addressee, (String)"addressee");
        return this.send(addressee, nickname, subject, body, null);
    }

    public final boolean send(@NotNull String addressee, @Nullable String subject, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)addressee, (String)"addressee");
        return this.send(addressee, null, subject, body);
    }

    private static final Session smtpSession_delegate$lambda$0(MailTools this$0) {
        return this$0.getSession(MailProtocols.SMTP);
    }

    public static final /* synthetic */ MailProps access$getMailProps$p(MailTools $this) {
        return $this.mailProps;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MailProtocols.values().length];
            try {
                nArray[MailProtocols.POP3.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MailProtocols.IMAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MailProtocols.SMTP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MailType.values().length];
            try {
                nArray[MailType.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MailType.HTML.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

