/*
 * Decompiled with CFR 0.152.
 */
package cn.starrys.tool.mail;

import cn.starrys.tool.mail.LoginAuthenticator;
import cn.starrys.tool.mail.entity.Mail;
import cn.starrys.tool.mail.entity.MailProps;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B;\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0004\u0010\u000fB3\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0010B)\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0011J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ\u001f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020+J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(J8\u0010)\u001a\u00020\u000e2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0!2\b\u0010-\u001a\u0004\u0018\u00010\u00072\b\u0010.\u001a\u0004\u0018\u00010\u00072\u000e\u0010/\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010!J<\u0010)\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010-\u001a\u0004\u0018\u00010\u00072\b\u0010.\u001a\u0004\u0018\u00010\u00072\u000e\u0010/\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010!J,\u0010)\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010-\u001a\u0004\u0018\u00010\u00072\b\u0010.\u001a\u0004\u0018\u00010\u0007J\"\u0010)\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u00072\b\u0010-\u001a\u0004\u0018\u00010\u00072\b\u0010.\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00062"}, d2={"Lcn/starrys/tool/mail/MailTools;", "", "mps", "Lcn/starrys/tool/mail/entity/MailProps;", "<init>", "(Lcn/starrys/tool/mail/entity/MailProps;)V", "host", "", "port", "", "from", "password", "nickname", "ssl", "", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "smtp", "Ljakarta/mail/Session;", "getSmtp", "()Ljakarta/mail/Session;", "smtp$delegate", "Lkotlin/Lazy;", "getSession", "protocol", "Lcn/starrys/tool/mail/entity/MailProps$Protocols;", "cia", "", "Ljakarta/mail/internet/InternetAddress;", "addresseeList", "", "Lcn/starrys/tool/mail/entity/Mail$Addressee;", "(Ljava/util/List;)[Ljakarta/mail/internet/InternetAddress;", "createMimeMessage", "Ljakarta/mail/internet/MimeMessage;", "session", "mail", "Lcn/starrys/tool/mail/entity/Mail;", "send", "message", "Ljakarta/mail/Message;", "to", "subject", "body", "attachments", "Ljava/io/File;", "addressee", "starry-mail"})
@SourceDebugExtension(value={"SMAP\nMailTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MailTools.kt\ncn/starrys/tool/mail/MailTools\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,240:1\n1#2:241\n1557#3:242\n1628#3,3:243\n1863#3,2:250\n37#4:246\n36#4,3:247\n*S KotlinDebug\n*F\n+ 1 MailTools.kt\ncn/starrys/tool/mail/MailTools\n*L\n111#1:242\n111#1:243,3\n147#1:250,2\n113#1:246\n113#1:247,3\n*E\n"})
public final class MailTools {
    @NotNull
    private final MailProps mps;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy smtp$delegate;

    public MailTools(@NotNull MailProps mps) {
        Intrinsics.checkNotNullParameter((Object)mps, (String)"mps");
        this.mps = mps;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.smtp$delegate = LazyKt.lazy(() -> MailTools.smtp_delegate$lambda$0(this));
    }

    private final Session getSmtp() {
        Lazy lazy = this.smtp$delegate;
        return (Session)lazy.getValue();
    }

    public MailTools(@NotNull String host, int port, @NotNull String from, @NotNull String password, @Nullable String nickname, boolean ssl) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this(new MailProps(host, port, from, password, nickname, ssl, false, Charsets.UTF_8, true));
    }

    public MailTools(@NotNull String host, int port, @NotNull String from, @NotNull String password, @Nullable String nickname) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this(host, port, from, password, nickname, true);
    }

    public MailTools(@NotNull String host, int port, @NotNull String from, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this(host, port, from, password, null);
    }

    @NotNull
    public final Session getSession(@NotNull MailProps.Protocols protocol) {
        Properties properties;
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Properties $this$getSession_u24lambda_u242 = properties = new Properties();
        boolean bl = false;
        $this$getSession_u24lambda_u242.put("mail.host", this.mps.getHost());
        $this$getSession_u24lambda_u242.put("mail." + protocol + ".port", (Object)this.mps.getPort());
        $this$getSession_u24lambda_u242.put("mail.from", this.mps.getFrom());
        $this$getSession_u24lambda_u242.put("mail.password", this.mps.getPassword());
        String string = this.mps.getNickname();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$getSession_u24lambda_u242.put("mail.user", it);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[protocol.ordinal()]) {
            case 1: 
            case 2: {
                Object object = $this$getSession_u24lambda_u242.put("mail.store.protocol", String.valueOf((Object)protocol));
                break;
            }
            case 3: {
                Object object = $this$getSession_u24lambda_u242.put("mail.transport.protocol", String.valueOf((Object)protocol));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$getSession_u24lambda_u242.put("mail." + protocol + ".auth", String.valueOf(this.mps.getAuth()));
        $this$getSession_u24lambda_u242.put("mail." + protocol + ".ssl.enable", String.valueOf(this.mps.getSsl()));
        $this$getSession_u24lambda_u242.put("mail." + protocol + ".ssl.socketFactory", "org.eclipse.angus.mail.util.MailSSLSocketFactory");
        $this$getSession_u24lambda_u242.put("mail.debug", String.valueOf(this.mps.getDebug()));
        Properties props = properties;
        if (this.mps.getAuth()) {
            Session session = Session.getInstance((Properties)props, (Authenticator)new LoginAuthenticator(this.mps.getFrom(), this.mps.getPassword()));
            Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getInstance(...)");
            return session;
        }
        Session session = Session.getInstance((Properties)props);
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"getInstance(...)");
        return session;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final InternetAddress[] cia(@NotNull List<Mail.Addressee> addresseeList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(addresseeList, (String)"addresseeList");
        Iterable $this$map$iv = addresseeList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void ma;
            Mail.Addressee addressee = (Mail.Addressee)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new InternetAddress(ma.getAddressee(), ma.getNickname(), this.mps.getCharset().name()));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new InternetAddress[0]);
    }

    @NotNull
    public final MimeMessage createMimeMessage(@NotNull Session session, @NotNull Mail mail) {
        List<Mail.Addressee> it;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)mail, (String)"mail");
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.mps.getFrom(), this.mps.getNickname(), this.mps.getCharset().name()));
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])this.cia(mail.getTo()));
        List<Mail.Addressee> list = mail.getCc();
        if (list != null) {
            it = list;
            boolean bl = false;
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])this.cia(it));
        }
        List<Mail.Addressee> list2 = mail.getBcc();
        if (list2 != null) {
            it = list2;
            boolean bl = false;
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])this.cia(it));
        }
        mimeMessage.setSubject(mail.getSubject(), this.mps.getCharset().name());
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        switch (WhenMappings.$EnumSwitchMapping$1[mail.getType().ordinal()]) {
            case 1: {
                mimeBodyPart.setText(mail.getBody(), this.mps.getCharset().name());
                break;
            }
            case 2: {
                mimeBodyPart.setContent((Object)mail.getBody(), "text/html;charset=" + this.mps.getCharset().name());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        MimeMultipart mimeMultipart = new MimeMultipart("mixed");
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        List<File> list3 = mail.getAttachments();
        if (list3 != null) {
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MimeBodyPart mimeBodyPart2;
                File attachment = (File)element$iv;
                boolean bl = false;
                MimeBodyPart $this$createMimeMessage_u24lambda_u247_u24lambda_u246 = mimeBodyPart2 = new MimeBodyPart();
                boolean bl2 = false;
                $this$createMimeMessage_u24lambda_u247_u24lambda_u246.attachFile(attachment);
                mimeMultipart.addBodyPart((BodyPart)$this$createMimeMessage_u24lambda_u247_u24lambda_u246);
            }
        }
        mimeMessage.setContent((Multipart)mimeMultipart);
        mimeMessage.setSentDate(new Date());
        mimeMessage.saveChanges();
        return mimeMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean send(@NotNull Message message) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            if (this.mps.getAuth()) {
                Transport.send((Message)message);
            } else {
                AutoCloseable autoCloseable = (AutoCloseable)message.getSession().getTransport();
                Throwable throwable = null;
                try {
                    Transport it = (Transport)autoCloseable;
                    boolean bl2 = false;
                    it.connect(this.mps.getHost(), this.mps.getPort(), this.mps.getFrom(), this.mps.getPassword());
                    it.sendMessage(message, message.getAllRecipients());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            bl = true;
        }
        catch (MessagingException err) {
            this.logger.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01", (Throwable)err);
            bl = false;
        }
        return bl;
    }

    public final boolean send(@NotNull Mail mail) {
        Intrinsics.checkNotNullParameter((Object)mail, (String)"mail");
        return this.send((Message)this.createMimeMessage(this.getSmtp(), mail));
    }

    public final boolean send(@NotNull List<Mail.Addressee> to, @Nullable String subject, @Nullable String body, @Nullable List<? extends File> attachments) {
        Intrinsics.checkNotNullParameter(to, (String)"to");
        return this.send(new Mail(to, null, null, Mail.Type.HTML, subject, body, attachments));
    }

    public final boolean send(@NotNull String addressee, @Nullable String nickname, @Nullable String subject, @Nullable String body, @Nullable List<? extends File> attachments) {
        ArrayList<Mail.Addressee> arrayList;
        Intrinsics.checkNotNullParameter((Object)addressee, (String)"addressee");
        ArrayList<Mail.Addressee> $this$send_u24lambda_u249 = arrayList = new ArrayList<Mail.Addressee>();
        boolean bl = false;
        $this$send_u24lambda_u249.add(new Mail.Addressee(addressee, nickname));
        ArrayList<Mail.Addressee> to = arrayList;
        return this.send((List<Mail.Addressee>)to, subject, body, attachments);
    }

    public final boolean send(@NotNull String addressee, @Nullable String nickname, @Nullable String subject, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)addressee, (String)"addressee");
        return this.send(addressee, nickname, subject, body, null);
    }

    public final boolean send(@NotNull String addressee, @Nullable String subject, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)addressee, (String)"addressee");
        return this.send(addressee, null, subject, body);
    }

    private static final Session smtp_delegate$lambda$0(MailTools this$0) {
        return this$0.getSession(MailProps.Protocols.SMTP);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MailProps.Protocols.values().length];
            try {
                nArray[MailProps.Protocols.POP3.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MailProps.Protocols.IMAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MailProps.Protocols.SMTP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Mail.Type.values().length];
            try {
                nArray[Mail.Type.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mail.Type.HTML.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

