/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.session.timer;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.timer.api.TimerAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ClearInvalidLoginUserCacheTimer
implements TimerAction {
    private final CacheOperatorApi<LoginUser> loginUserCacheOperatorApi;
    private final CacheOperatorApi<Set<String>> allPlaceLoginTokenCache;

    public ClearInvalidLoginUserCacheTimer(CacheOperatorApi<LoginUser> loginUserCacheOperatorApi, CacheOperatorApi<Set<String>> allPlaceLoginTokenCache) {
        this.loginUserCacheOperatorApi = loginUserCacheOperatorApi;
        this.allPlaceLoginTokenCache = allPlaceLoginTokenCache;
    }

    public void action(String params) {
        Collection allOnlineUsers = this.allPlaceLoginTokenCache.getAllKeys();
        if (ObjectUtil.isNotEmpty((Object)allOnlineUsers)) {
            for (String userId : allOnlineUsers) {
                Set userTokens = (Set)this.allPlaceLoginTokenCache.get(userId);
                HashSet<String> newUserTokens = new HashSet<String>();
                for (String userToken : userTokens) {
                    LoginUser loginUser = (LoginUser)this.loginUserCacheOperatorApi.get(userToken);
                    if (loginUser == null) continue;
                    newUserTokens.add(userToken);
                }
                if (ObjectUtil.isEmpty(newUserTokens)) {
                    this.allPlaceLoginTokenCache.remove(new String[]{userId});
                    continue;
                }
                this.allPlaceLoginTokenCache.put(userId, newUserTokens);
            }
        }
    }
}

