/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.auth;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import cn.stylefeng.roses.kernel.auth.api.AuthServiceApi;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.context.AuthJwtContext;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.expander.AuthConfigExpander;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.auth.LoginResponse;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.auth.api.pojo.payload.DefaultJwtPayload;
import cn.stylefeng.roses.kernel.auth.api.pojo.sso.DecryptCaLoginUser;
import cn.stylefeng.roses.kernel.auth.api.pojo.sso.DecryptCaTokenInfo;
import cn.stylefeng.roses.kernel.auth.api.pojo.sso.LoginBySsoTokenRequest;
import cn.stylefeng.roses.kernel.auth.api.pojo.sso.LogoutBySsoTokenRequest;
import cn.stylefeng.roses.kernel.auth.auth.LoginService;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.demo.expander.DemoConfigExpander;
import cn.stylefeng.roses.kernel.jwt.api.JwtApi;
import cn.stylefeng.roses.kernel.jwt.api.exception.enums.JwtExceptionEnum;
import cn.stylefeng.roses.kernel.log.api.LoginLogServiceApi;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.sys.api.SysUserServiceApi;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.UserValidateDTO;
import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.JwtException;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements AuthServiceApi {
    @Resource
    private SysUserServiceApi sysUserServiceApi;
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private LoginLogServiceApi loginLogServiceApi;
    @Resource(name="loginErrorCountCacheApi")
    private CacheOperatorApi<Integer> loginErrorCountCacheApi;
    @Resource(name="caClientTokenCacheApi")
    private CacheOperatorApi<String> caClientTokenCacheApi;
    @Resource
    private JwtApi jwtApi;
    @Resource
    private LoginService loginService;

    public LoginResponse login(LoginRequest loginRequest) {
        return this.loginService.loginAction(loginRequest, true, null);
    }

    public LoginResponse loginWithUserName(String username) {
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setAccount(username);
        return this.loginService.loginAction(loginRequest, false, null);
    }

    public LoginResponse loginWithUserNameAndCaToken(String username, String caToken) {
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setAccount(username);
        return this.loginService.loginAction(loginRequest, false, caToken);
    }

    public LoginResponse LoginByCaToken(LoginBySsoTokenRequest loginWithTokenRequest) {
        String encryptUserInfo = loginWithTokenRequest.getToken();
        AES aesUtil = SecureUtil.aes((byte[])Base64.decode((CharSequence)AuthConfigExpander.getSsoDataDecryptSecret()));
        String userInfoJson = null;
        try {
            userInfoJson = aesUtil.decryptStr(encryptUserInfo, CharsetUtil.CHARSET_UTF_8);
        }
        catch (Exception e) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_TOKEN_PARSE_ERROR, new Object[]{"sso token\u65e0\u6cd5\u89e3\u6790"});
        }
        DecryptCaTokenInfo decryptCaTokenInfo = (DecryptCaTokenInfo)JSON.parseObject((String)userInfoJson, DecryptCaTokenInfo.class);
        String tokenGenerateTimeStr = decryptCaTokenInfo.getGenerationDateTime();
        DateTime tokenGenerateTime = DateUtil.parse((CharSequence)tokenGenerateTimeStr);
        DateTime tokenExpTime = tokenGenerateTime.offset(DateField.MINUTE, 2);
        if (tokenExpTime.isBefore(new Date())) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_TOKEN_PARSE_ERROR, new Object[]{"sso token\u8fc7\u671f"});
        }
        DecryptCaLoginUser caLoginUser = decryptCaTokenInfo.getCaLoginUser();
        if (caLoginUser == null) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_TOKEN_GET_USER_ERROR);
        }
        if (ObjectUtil.isEmpty((Object)caLoginUser.getAccount()) || ObjectUtil.isEmpty((Object)caLoginUser.getCaToken())) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.SSO_TOKEN_GET_USER_ERROR);
        }
        LoginResponse loginResponse = this.loginWithUserNameAndCaToken(caLoginUser.getAccount(), caLoginUser.getCaToken());
        this.caClientTokenCacheApi.put(caLoginUser.getCaToken(), (Object)loginResponse.getToken());
        return loginResponse;
    }

    public void logout() {
        String token = LoginContext.me().getToken();
        if (!DemoConfigExpander.getDemoEnvFlag().booleanValue() && StrUtil.isNotEmpty((CharSequence)token)) {
            this.loginLogServiceApi.loginOutSuccess(LoginContext.me().getLoginUser().getUserId());
        }
        this.logoutWithToken(token);
    }

    public void logoutWithToken(String token) {
        this.sessionManagerApi.removeSession(token);
    }

    public DefaultJwtPayload validateToken(String token) throws AuthException {
        try {
            this.jwtApi.validateTokenWithException(token);
            DefaultJwtPayload defaultPayload = AuthJwtContext.me().getDefaultPayload(token);
            if (defaultPayload.getRememberMe().booleanValue()) {
                return defaultPayload;
            }
            LoginUser session = this.sessionManagerApi.getSession(token);
            if (session == null) {
                throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.AUTH_EXPIRED_ERROR);
            }
            return defaultPayload;
        }
        catch (cn.stylefeng.roses.kernel.jwt.api.exception.JwtException jwtException) {
            if (JwtExceptionEnum.JWT_EXPIRED_ERROR.getErrorCode().equals(jwtException.getErrorCode())) {
                throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.AUTH_EXPIRED_ERROR);
            }
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_PARSE_ERROR);
        }
        catch (JwtException jwtSelfException) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_PARSE_ERROR);
        }
    }

    public void checkAuth(String token, String requestUrl) {
        if (StrUtil.isEmpty((CharSequence)token)) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.TOKEN_GET_ERROR);
        }
        this.validateToken(token);
    }

    public void cancelFreeze(LoginRequest loginRequest) {
        this.loginErrorCountCacheApi.remove(new String[]{loginRequest.getAccount()});
    }

    public LoginUser createNewLoginInfo(String token, DefaultJwtPayload defaultJwtPayload) {
        Long userId = defaultJwtPayload.getUserId();
        UserValidateDTO userValidateDTO = this.sysUserServiceApi.getUserLoginValidateDTO(userId);
        LoginUser loginUser = new LoginUser(userValidateDTO.getUserId(), userValidateDTO.getAccount(), token, userValidateDTO.getTenantId());
        this.sessionManagerApi.updateSession(token, loginUser);
        return loginUser;
    }

    public void logoutByCaToken(LogoutBySsoTokenRequest logoutBySsoTokenRequest) {
        String localGunsToken = (String)this.caClientTokenCacheApi.get(logoutBySsoTokenRequest.getCaToken());
        if (ObjectUtil.isEmpty((Object)localGunsToken)) {
            return;
        }
        this.sessionManagerApi.removeSession(localGunsToken);
    }
}

