/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.session;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultSessionManager
implements SessionManagerApi {
    private final CacheOperatorApi<LoginUser> loginUserCache;
    private final CacheOperatorApi<Set<String>> allPlaceLoginTokenCache;
    private final Long sessionExpiredSeconds;

    public DefaultSessionManager(CacheOperatorApi<LoginUser> loginUserCache, CacheOperatorApi<Set<String>> allPlaceLoginTokenCache, Long sessionExpiredSeconds) {
        this.loginUserCache = loginUserCache;
        this.allPlaceLoginTokenCache = allPlaceLoginTokenCache;
        this.sessionExpiredSeconds = sessionExpiredSeconds;
    }

    public void createSession(String token, LoginUser loginUser) {
        this.loginUserCache.put(token, (Object)loginUser, this.sessionExpiredSeconds);
        HashSet<String> theUserTokens = (HashSet<String>)this.allPlaceLoginTokenCache.get(loginUser.getUserId().toString());
        if (theUserTokens == null) {
            theUserTokens = new HashSet<String>();
        }
        theUserTokens.add(token);
        this.allPlaceLoginTokenCache.put(loginUser.getUserId().toString(), theUserTokens);
    }

    public void updateSession(String token, LoginUser loginUser) {
        if (StrUtil.isEmpty((CharSequence)token) || ObjectUtil.isEmpty((Object)loginUser)) {
            return;
        }
        this.loginUserCache.put(token, (Object)loginUser, this.sessionExpiredSeconds);
    }

    public LoginUser getSession(String token) {
        return (LoginUser)this.loginUserCache.get(token);
    }

    public void removeSession(String token) {
        Long userId;
        Set userTokens;
        LoginUser loginUser = (LoginUser)this.loginUserCache.get(token);
        this.loginUserCache.remove(new String[]{token});
        if (loginUser != null && (userTokens = (Set)this.allPlaceLoginTokenCache.get((userId = loginUser.getUserId()).toString())) != null) {
            userTokens.remove(token);
            this.allPlaceLoginTokenCache.put(userId.toString(), (Object)userTokens);
            if (userTokens.size() == 0) {
                this.allPlaceLoginTokenCache.remove(new String[]{userId.toString()});
            }
        }
    }

    public void removeSessionExcludeToken(String token) {
        LoginUser session = this.getSession(token);
        if (session == null) {
            return;
        }
        Long userId = session.getUserId();
        Set thisUserTokens = (Set)this.allPlaceLoginTokenCache.get(userId.toString());
        for (String thisUserToken : thisUserTokens) {
            if (thisUserToken.equals(token)) continue;
            this.loginUserCache.remove(new String[]{thisUserToken});
        }
        HashSet<String> tokenSet = new HashSet<String>();
        tokenSet.add(token);
        this.allPlaceLoginTokenCache.put(userId.toString(), tokenSet);
    }

    public boolean haveSession(String token) {
        return this.loginUserCache.contains(token);
    }

    public void refreshSession(String token) {
        LoginUser loginUser = (LoginUser)this.loginUserCache.get(token);
        if (loginUser != null) {
            this.loginUserCache.expire(token, this.sessionExpiredSeconds);
        }
    }

    public List<LoginUser> onlineUserList() {
        Map allKeyValues = this.loginUserCache.getAllKeyValues();
        ArrayList<LoginUser> loginUsers = new ArrayList<LoginUser>();
        for (Map.Entry userEntry : allKeyValues.entrySet()) {
            String token = (String)userEntry.getKey();
            LoginUser loginUser = (LoginUser)userEntry.getValue();
            LoginUser tempUser = new LoginUser();
            BeanUtil.copyProperties((Object)loginUser, (Object)tempUser, (String[])new String[0]);
            tempUser.setToken(token);
            loginUsers.add(tempUser);
        }
        return loginUsers;
    }
}

