/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.biz.file.config;

import cn.stylefeng.roses.biz.file.config.properties.OssProperteis;
import cn.stylefeng.roses.biz.file.core.db.FileInitializer;
import cn.stylefeng.roses.biz.file.core.storage.FileOperator;
import cn.stylefeng.roses.biz.file.core.storage.oss.OssFileOperator;
import cn.stylefeng.roses.biz.file.modular.controller.FileController;
import cn.stylefeng.roses.biz.file.modular.controller.FileManagerController;
import cn.stylefeng.roses.biz.file.modular.provider.FileinfoServiceProvider;
import cn.stylefeng.roses.biz.file.modular.service.FileinfoService;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"cn.stylefeng.roses.biz.file"})
public class FileAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="aliyun.oss")
    public OssProperteis ossProperteis() {
        return new OssProperteis();
    }

    @Bean
    public OSSClient ossClient(OssProperteis ossProperteis) {
        DefaultCredentialProvider defaultCredentialProvider = new DefaultCredentialProvider(ossProperteis.getAccessKeyId(), ossProperteis.getAccessKeySecret());
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        return new OSSClient(ossProperteis.getEndpoint(), (CredentialsProvider)defaultCredentialProvider, clientConfiguration);
    }

    @Bean
    public FileOperator fileOperator(OSSClient ossClient, OssProperteis ossProperteis) {
        return new OssFileOperator(ossClient, ossProperteis);
    }

    @Bean
    public FileInitializer fileInitializer() {
        return new FileInitializer();
    }

    @Bean
    public FileController fileController() {
        return new FileController();
    }

    @Bean
    public FileManagerController fileManagerController() {
        return new FileManagerController();
    }

    @Bean
    public FileinfoService fileinfoService() {
        return new FileinfoService();
    }

    @Bean
    public FileinfoServiceProvider fileinfoServiceProvider() {
        return new FileinfoServiceProvider();
    }
}

