/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.biz.file.core.storage.oss;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.stylefeng.roses.biz.file.config.properties.OssProperteis;
import cn.stylefeng.roses.biz.file.core.exceptions.FileExceptionEnum;
import cn.stylefeng.roses.biz.file.core.storage.FileOperator;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.model.exception.AbstractBaseExceptionEnum;
import cn.stylefeng.roses.kernel.model.exception.ServiceException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssFileOperator
implements FileOperator {
    private static final Logger log = LoggerFactory.getLogger(OssFileOperator.class);
    private OssProperteis ossProperteis;
    private OSSClient ossClient;

    public OssFileOperator(OSSClient ossClient, OssProperteis ossProperteis) {
        this.ossClient = ossClient;
        this.ossProperteis = ossProperteis;
    }

    @Override
    public boolean isExistingFile(String fileName) {
        try {
            this.ossClient.getObject(this.ossProperteis.getBucketName(), fileName);
        }
        catch (ClientException | OSSException e) {
            log.info("\u963f\u91cc\u4e91\u4e0a\u627e\u4e0d\u5230\u8be5\u6587\u4ef6\uff01\u6587\u4ef6\u540d\uff1a" + fileName);
            return false;
        }
        return true;
    }

    @Override
    public byte[] getFileBytes(String fileName) {
        OSSObject object = null;
        try {
            object = this.ossClient.getObject(this.ossProperteis.getBucketName(), fileName);
        }
        catch (ClientException | OSSException e) {
            log.info("\u963f\u91cc\u4e91\u4e0a\u627e\u4e0d\u5230\u8be5\u6587\u4ef6\uff01\u6587\u4ef6\u540d\uff1a" + fileName);
            throw new ServiceException((AbstractBaseExceptionEnum)FileExceptionEnum.FILE_NOT_FOUND);
        }
        InputStream objectContent = null;
        try {
            objectContent = object.getObjectContent();
            byte[] byArray = IoUtil.readBytes((InputStream)objectContent);
            return byArray;
        }
        catch (IORuntimeException e) {
            log.error("\u6d41\u8bfb\u53d6\u9519\u8bef\uff01", (Throwable)e);
            throw new ServiceException((AbstractBaseExceptionEnum)FileExceptionEnum.IO_ERROR);
        }
        finally {
            IoUtil.close((Closeable)objectContent);
        }
    }

    @Override
    public void storageFile(String fileName, InputStream inputStream) {
        this.ossClient.putObject(this.ossProperteis.getBucketName(), fileName, inputStream);
    }

    @Override
    public void storageFile(String fileName, byte[] bytes) {
        this.ossClient.putObject(this.ossProperteis.getBucketName(), fileName, (InputStream)new ByteArrayInputStream(bytes));
    }

    @Override
    public boolean copyFile(String sourceFileFinalName, String newFileFinalName) {
        CopyObjectRequest copyObjectFile = new CopyObjectRequest(this.ossProperteis.getBucketName(), sourceFileFinalName, this.ossProperteis.getBucketName(), newFileFinalName);
        ObjectMetadata meta = new ObjectMetadata();
        copyObjectFile.setNewObjectMetadata(meta);
        try {
            this.ossClient.copyObject(copyObjectFile);
        }
        catch (Exception e) {
            log.error("oss\u62f7\u8d1d\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public String getFileAuthUrl(String fileFinalName) {
        if (ToolUtil.isEmpty((Object)fileFinalName)) {
            return null;
        }
        Date expiration = new Date(System.currentTimeMillis() + (long)(this.ossProperteis.getExpiredMinutes() * 1000));
        URL url = this.ossClient.generatePresignedUrl(this.ossProperteis.getBucketName(), fileFinalName, expiration);
        return url.toString();
    }
}

