/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.biz.file.modular.controller;

import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.core.io.IoUtil;
import cn.stylefeng.roses.biz.file.api.entity.Fileinfo;
import cn.stylefeng.roses.biz.file.core.exceptions.FileExceptionEnum;
import cn.stylefeng.roses.biz.file.core.storage.FileOperator;
import cn.stylefeng.roses.biz.file.core.util.FileUtil;
import cn.stylefeng.roses.biz.file.modular.service.FileinfoService;
import cn.stylefeng.roses.core.reqres.response.ResponseData;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.model.exception.AbstractBaseExceptionEnum;
import cn.stylefeng.roses.kernel.model.exception.RequestEmptyException;
import cn.stylefeng.roses.kernel.model.exception.ServiceException;
import cn.stylefeng.roses.kernel.scanner.modular.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.modular.annotation.PostResource;
import cn.stylefeng.roses.kernel.scanner.modular.stereotype.ApiResource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@ApiResource(name="\u6587\u4ef6\u7ba1\u7406", path={"/file"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private FileinfoService fileinfoService;
    @Autowired
    private FileOperator fileOperator;

    @PostResource(name="\u6587\u4ef6\u4e0a\u4f20", path={"/upload"})
    public ResponseData upload(MultipartHttpServletRequest multiReq) {
        MultipartFile file = multiReq.getFile("file");
        if (file == null) {
            throw new RequestEmptyException("\u4f20\u9012file\u4e3a\u7a7a\uff01");
        }
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u65f6\uff0c\u8bfb\u53d6\u6587\u4ef6\u6d41\u9519\u8bef\uff01", (Throwable)e);
            throw new ServiceException((AbstractBaseExceptionEnum)FileExceptionEnum.IO_ERROR);
        }
        String fileName = file.getOriginalFilename();
        if (ToolUtil.isEmpty((Object)fileName)) {
            throw new ServiceException((AbstractBaseExceptionEnum)FileExceptionEnum.FILE_NOT_FOUND);
        }
        log.info("\u6587\u4ef6\u7cfb\u7edf\u4e2d\u7684\u4e0a\u4f20\u6587\u4ef6\u540d\u79f0\uff1a------------------" + fileName);
        long size = file.getSize();
        String fileId = this.fileinfoService.uploadFileAndSaveFileInfo(inputStream, fileName, size);
        if (fileId == null) {
            return ResponseData.success();
        }
        return ResponseData.success((Object)fileId);
    }

    @GetResource(name="\u6587\u4ef6\u4e0b\u8f7d", path={"/download"})
    public void downloadFile(HttpServletRequest request, HttpServletResponse response) {
        Long fileIdLong;
        String fileId = request.getParameter("fileId");
        if (ToolUtil.isEmpty((Object)fileId)) {
            throw new RequestEmptyException("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
        }
        try {
            fileIdLong = Long.valueOf(fileId);
        }
        catch (NumberFormatException e) {
            throw new ServiceException((AbstractBaseExceptionEnum)FileExceptionEnum.FILE_NAME_ERROR);
        }
        Fileinfo fileinfo = this.fileinfoService.getFileInfo(fileIdLong);
        String fileOriginName = FileUtil.getFileName(fileinfo.getFileOriginName(), fileinfo.getFileSuffix());
        try {
            fileOriginName = new String(fileOriginName.getBytes(), "ISO-8859-1");
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e2d\u6587\u540d\u79f0\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new ServiceException((AbstractBaseExceptionEnum)FileExceptionEnum.FILE_NAME_FORMAT_ERROR);
        }
        response.setContentType("application/octet-stream; charset=utf-8");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileOriginName);
        byte[] fileBytes = this.fileOperator.getFileBytes(fileinfo.getFileStorageName());
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(fileBytes);
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new ServiceException((AbstractBaseExceptionEnum)FileExceptionEnum.IO_ERROR);
        }
        finally {
            IoUtil.close((Closeable)out);
        }
    }

    @GetResource(name="\u9884\u89c8\u6587\u4ef6", path={"/preview"})
    public void preview(HttpServletRequest request, HttpServletResponse response) {
        String fileId = request.getParameter("fileId");
        if (ToolUtil.isEmpty((Object)fileId)) {
            throw new RequestEmptyException("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
        }
        String fileUrl = this.fileinfoService.getFileUrlById(Long.valueOf(fileId));
        try {
            response.sendRedirect(fileUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @GetResource(name="\u9884\u89c8\u6587\u4ef6base64", path={"/previewBase64"})
    public String previewBase64(HttpServletRequest request, HttpServletResponse response) {
        String fileId = request.getParameter("fileId");
        if (ToolUtil.isEmpty((Object)fileId)) {
            throw new RequestEmptyException("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
        }
        Fileinfo fileinfo = this.fileinfoService.getFileInfo(Long.valueOf(fileId));
        String filePath = fileinfo.getFileStorageName();
        if (ToolUtil.isEmpty((Object)filePath)) {
            throw new ServiceException((AbstractBaseExceptionEnum)FileExceptionEnum.FILE_NOT_FOUND);
        }
        try {
            byte[] fileBytes = this.fileOperator.getFileBytes(filePath);
            return Base64Encoder.encode((byte[])fileBytes);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)e);
            throw new ServiceException((AbstractBaseExceptionEnum)FileExceptionEnum.IO_ERROR);
        }
    }
}

