/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.biz.file.modular.factory;

import cn.stylefeng.roses.biz.file.api.entity.Fileinfo;
import cn.stylefeng.roses.biz.file.config.properties.OssProperteis;
import cn.stylefeng.roses.biz.file.core.util.FileUtil;
import cn.stylefeng.roses.core.util.SpringContextHolder;
import cn.stylefeng.roses.core.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFactory {
    private static final Logger log = LoggerFactory.getLogger(FileFactory.class);

    public static Fileinfo getFileInfo(String appCode, String fileOriginName, Long fileSize, Long fileId, String fileStorageName) {
        if (ToolUtil.isEmpty((Object)appCode)) {
            appCode = "noneAppCode";
        }
        Fileinfo fileinfo = new Fileinfo();
        fileinfo.setFileId(fileId);
        fileinfo.setAppCode(appCode);
        fileinfo.setFileOriginName(fileOriginName);
        fileinfo.setFileSuffix(FileUtil.getFileSuffix(fileOriginName));
        fileinfo.setFileSize(fileSize);
        fileinfo.setFileStorageName(fileStorageName);
        try {
            OssProperteis ossProperteis = (OssProperteis)SpringContextHolder.getBean(OssProperteis.class);
            fileinfo.setFileUrl(ossProperteis.getInternetFileUrl() + fileStorageName);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6ossProperties\u5931\u8d25\uff01\u5b58\u50a8\u6587\u4ef6\u5730\u5740\u4e3a\uff1b" + fileStorageName);
            fileinfo.setFileUrl(fileStorageName);
        }
        return fileinfo;
    }
}

