/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.biz.file.modular.service;

import cn.hutool.core.io.IoUtil;
import cn.stylefeng.roses.biz.file.api.entity.Fileinfo;
import cn.stylefeng.roses.biz.file.core.exceptions.FileExceptionEnum;
import cn.stylefeng.roses.biz.file.core.storage.FileOperator;
import cn.stylefeng.roses.biz.file.core.util.FileUtil;
import cn.stylefeng.roses.biz.file.modular.factory.FileFactory;
import cn.stylefeng.roses.biz.file.modular.mapper.FileinfoMapper;
import cn.stylefeng.roses.core.page.PageFactory;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.model.exception.AbstractBaseExceptionEnum;
import cn.stylefeng.roses.kernel.model.exception.RequestEmptyException;
import cn.stylefeng.roses.kernel.model.exception.ServiceException;
import cn.stylefeng.roses.kernel.model.exception.enums.CoreExceptionEnum;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FileinfoService
extends ServiceImpl<FileinfoMapper, Fileinfo> {
    @Autowired
    private FileOperator fileOperator;

    public Fileinfo getFileInfo(Long fileId) {
        Fileinfo fileinfo = (Fileinfo)this.selectById(fileId);
        if (fileinfo == null) {
            throw new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.FILE_NOT_FOUND);
        }
        return fileinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public String uploadFileAndSaveFileInfo(InputStream inputStream, String fileName, Long size) {
        try {
            long uuid = IdWorker.getId();
            String storageName = uuid + "." + FileUtil.getFileSuffix(fileName);
            this.fileOperator.storageFile(storageName, inputStream);
            Fileinfo fileInfo = FileFactory.getFileInfo("", fileName, size, uuid, storageName);
            this.insert(fileInfo);
            String string = Long.toString(uuid);
            return string;
        }
        finally {
            IoUtil.close((Closeable)inputStream);
        }
    }

    public String getFileUrlById(Long fileId) {
        if (ToolUtil.isEmpty((Object)fileId)) {
            throw new RequestEmptyException("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
        }
        Fileinfo fileinfo = (Fileinfo)this.selectById(fileId);
        if (fileinfo == null) {
            throw new ServiceException((AbstractBaseExceptionEnum)FileExceptionEnum.FILE_NOT_FOUND);
        }
        return this.fileOperator.getFileAuthUrl(fileinfo.getFileStorageName());
    }

    public List<Fileinfo> getFileInfoList(Page page, Fileinfo fileinfo) {
        if (page == null) {
            page = PageFactory.defaultPage();
        }
        if (fileinfo == null) {
            fileinfo = new Fileinfo();
        }
        return ((FileinfoMapper)this.baseMapper).getFileInfoList(page, fileinfo);
    }
}

