/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.config;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.config.api.ConfigApi;
import cn.stylefeng.roses.kernel.config.api.exception.ConfigException;
import cn.stylefeng.roses.kernel.config.api.exception.enums.ConfigExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigContainer
implements ConfigApi {
    private static final Logger log = LoggerFactory.getLogger(ConfigContainer.class);
    private static final Dict CONFIG_CONTAINER = Dict.create();

    public void initConfig(Map<String, Object> configs) {
        if (configs == null || configs.size() == 0) {
            return;
        }
        CONFIG_CONTAINER.putAll(configs);
    }

    public Map<String, Object> getAllConfigs() {
        return CONFIG_CONTAINER;
    }

    public Set<String> getAllConfigKeys() {
        return CONFIG_CONTAINER.keySet();
    }

    public void putConfig(String key, Object value) {
        CONFIG_CONTAINER.put(key, value);
    }

    public void deleteConfig(String key) {
        CONFIG_CONTAINER.remove((Object)key);
    }

    public <T> T getConfigValue(String configCode, Class<T> clazz) throws ConfigException {
        String configValue = CONFIG_CONTAINER.getStr(configCode);
        if (ObjectUtil.isEmpty((Object)configValue)) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_NOT_EXIST, new Object[]{configCode});
        }
        try {
            return (T)Convert.convert(clazz, (Object)configValue);
        }
        catch (Exception e) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONVERT_ERROR, new Object[]{configCode, configValue, clazz.toString()});
        }
    }

    public <T> T getConfigValueNullable(String configCode, Class<T> clazz) {
        String configValue = CONFIG_CONTAINER.getStr(configCode);
        if (ObjectUtil.isEmpty((Object)configValue)) {
            String format = StrUtil.format((CharSequence)ConfigExceptionEnum.CONFIG_NOT_EXIST.getUserTip(), (Object[])new Object[]{configCode});
            log.warn(format);
            return null;
        }
        try {
            return (T)Convert.convert(clazz, (Object)configValue);
        }
        catch (Exception e) {
            String format = StrUtil.format((CharSequence)ConfigExceptionEnum.CONVERT_ERROR.getUserTip(), (Object[])new Object[]{configCode, configValue, clazz.toString()});
            log.warn(format);
            return null;
        }
    }

    public <T> T getSysConfigValueWithDefault(String configCode, Class<T> clazz, T defaultValue) {
        T value = this.getConfigValueNullable(configCode, clazz);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

