/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.config.redis;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.config.api.ConfigApi;
import cn.stylefeng.roses.kernel.config.api.exception.ConfigException;
import cn.stylefeng.roses.kernel.config.api.exception.enums.ConfigExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisConfigContainer
implements ConfigApi {
    private static final Logger log = LoggerFactory.getLogger(RedisConfigContainer.class);
    private JedisPool pool = null;
    private final String CONFIG_PREFIX = "SYS_CONFIG_CACHE:";

    public RedisConfigContainer(String redisHost, Integer redisPort, String redisPassword, Integer dbNumber) {
        if (StrUtil.isEmpty((CharSequence)redisHost)) {
            redisHost = "localhost";
        }
        if (ObjectUtil.isEmpty((Object)redisPort)) {
            redisPort = 6379;
        }
        if (StrUtil.isEmpty((CharSequence)redisPassword)) {
            redisPassword = null;
        }
        if (ObjectUtil.isEmpty((Object)dbNumber)) {
            dbNumber = 0;
        }
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(50);
        jedisPoolConfig.setMinIdle(5);
        jedisPoolConfig.setMaxWaitMillis(100000L);
        jedisPoolConfig.setTestOnBorrow(true);
        jedisPoolConfig.setTestOnReturn(true);
        this.pool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, redisHost, redisPort.intValue(), 3000, redisPassword, dbNumber.intValue());
    }

    public void initConfig(Map<String, Object> configs) {
        if (configs == null || configs.size() == 0) {
            return;
        }
        try (Jedis jedis = this.pool.getResource();){
            for (Map.Entry<String, Object> stringObjectEntry : configs.entrySet()) {
                String key = stringObjectEntry.getKey();
                Object value = stringObjectEntry.getValue();
                if (value == null) continue;
                jedis.set("SYS_CONFIG_CACHE:" + key, value.toString());
            }
        }
    }

    public Map<String, Object> getAllConfigs() {
        try (Jedis jedis = this.pool.getResource();){
            Set keys = jedis.keys("SYS_CONFIG_CACHE:*");
            HashMap<String, String> result = new HashMap<String, String>();
            if (ObjectUtil.isNotEmpty((Object)keys)) {
                for (String key : keys) {
                    result.put(key.substring("SYS_CONFIG_CACHE:".length()), jedis.get(key));
                }
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
    }

    public Set<String> getAllConfigKeys() {
        try (Jedis jedis = this.pool.getResource();){
            Set keys = jedis.keys("SYS_CONFIG_CACHE:*");
            HashSet<String> result = new HashSet<String>();
            if (ObjectUtil.isNotEmpty((Object)keys)) {
                for (String key : keys) {
                    result.add(key.substring("SYS_CONFIG_CACHE:".length()));
                }
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
    }

    public void putConfig(String key, Object value) {
        try (Jedis jedis = this.pool.getResource();){
            if (ObjectUtil.isNotEmpty((Object)value)) {
                jedis.set("SYS_CONFIG_CACHE:" + key, value.toString());
            }
        }
    }

    public void deleteConfig(String key) {
        try (Jedis jedis = this.pool.getResource();){
            if (ObjectUtil.isNotEmpty((Object)key)) {
                jedis.del("SYS_CONFIG_CACHE:" + key);
            }
        }
    }

    public <T> T getConfigValue(String configCode, Class<T> clazz) throws ConfigException {
        Throwable throwable = null;
        try (Jedis jedis = this.pool.getResource();){
            Object object;
            String configValue = jedis.get("SYS_CONFIG_CACHE:" + configCode);
            if (ObjectUtil.isEmpty((Object)configValue)) {
                throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_NOT_EXIST, new Object[]{configCode});
            }
            try {
                object = Convert.convert(clazz, (Object)configValue);
            }
            catch (Exception e) {
                try {
                    throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONVERT_ERROR, new Object[]{configCode, configValue, clazz.toString()});
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            return (T)object;
        }
    }

    public <T> T getConfigValueNullable(String configCode, Class<T> clazz) {
        try (Jedis jedis = this.pool.getResource();){
            String configValue = jedis.get("SYS_CONFIG_CACHE:" + configCode);
            if (ObjectUtil.isEmpty((Object)configValue)) {
                String format = StrUtil.format((CharSequence)ConfigExceptionEnum.CONFIG_NOT_EXIST.getUserTip(), (Object[])new Object[]{configCode});
                log.warn(format);
                T t = null;
                return t;
            }
            Object format = Convert.convert(clazz, (Object)configValue);
            return (T)format;
        }
    }

    public <T> T getSysConfigValueWithDefault(String configCode, Class<T> clazz, T defaultValue) {
        T value = this.getConfigValueNullable(configCode, clazz);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

