/*
 * Copyright [2020-2030] [https://www.stylefeng.cn]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Guns采用APACHE LICENSE 2.0开源协议，您在使用过程中，需要注意以下几点：
 *
 * 1.请不要删除和修改根目录下的LICENSE文件。
 * 2.请不要删除和修改Guns源码头部的版权声明。
 * 3.请保留源码和相关描述文件的项目出处，作者声明等。
 * 4.分发源码时候，请注明软件出处 https://gitee.com/stylefeng/guns
 * 5.在修改包名，模块名称，项目代码等时，请注明软件出处 https://gitee.com/stylefeng/guns
 * 6.若您的项目无法满足以上几点，可申请商业授权
 */
package cn.stylefeng.roses.kernel.customer.api;

import cn.stylefeng.roses.kernel.customer.api.pojo.CustomerInfo;

import java.util.Date;

/**
 * C端用户api
 *
 * @author fengshuonan
 * @since 2021/6/7 11:31
 */
public interface CustomerApi {

    /**
     * 获取C端用户的详细信息
     *
     * @author fengshuonan
     * @since 2021/6/8 21:25
     */
    CustomerInfo getCustomerInfoById(Long customerId);

    /**
     * 获取用户信息，通过用户的secretKey字段
     *
     * @author fengshuonan
     * @since 2021/7/20 10:51
     */
    CustomerInfo getCustomerInfoBySecretKey(String secretKey);

    /**
     * 更新用户会员时间
     *
     * @author fengshuonan
     * @since 2021/7/18 22:16
     */
    void updateMemberExpiryDate(Long customerId, Date expiryDate);

    /**
     * 重置个人秘钥
     *
     * @param customerId 用户id
     * @return 用户秘钥
     * @author fengshuonan
     * @since 2021/7/20 10:44
     */
    String createOrUpdateCustomerSecret(Long customerId);

    /**
     * 获取用户信息
     *
     * @param keyWords 用户账号，邮箱，或用户id
     * @author fengshuonan
     * @since 2021/7/20 10:44
     */
    CustomerInfo getCustomerInfoByKeyWords(String keyWords);

}
