/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.customer.modular.controller;

import cn.stylefeng.roses.kernel.customer.modular.entity.Customer;
import cn.stylefeng.roses.kernel.customer.modular.request.CustomerRequest;
import cn.stylefeng.roses.kernel.customer.modular.service.CustomerService;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.annotation.BusinessLog;
import cn.stylefeng.roses.kernel.rule.enums.ResBizTypeEnum;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="C\u7aef\u7528\u6237\u8868", resBizType=ResBizTypeEnum.SYSTEM)
public class CustomerManageController {
    @Resource
    private CustomerService customerService;

    @PostResource(name="\u6dfb\u52a0", path={"/customer/add"})
    @BusinessLog
    public ResponseData<?> add(@RequestBody @Validated(value={BaseRequest.add.class}) CustomerRequest customerRequest) {
        this.customerService.add(customerRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u5220\u9664", path={"/customer/delete"})
    @BusinessLog
    public ResponseData<?> delete(@RequestBody @Validated(value={BaseRequest.delete.class}) CustomerRequest customerRequest) {
        this.customerService.del(customerRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u7f16\u8f91", path={"/customer/edit"})
    @BusinessLog
    public ResponseData<?> edit(@RequestBody @Validated(value={BaseRequest.edit.class}) CustomerRequest customerRequest) {
        this.customerService.edit(customerRequest);
        return new SuccessResponseData();
    }

    @GetResource(name="\u67e5\u770b\u8be6\u60c5", path={"/customer/detail"})
    public ResponseData<Customer> detail(@Validated(value={BaseRequest.detail.class}) CustomerRequest customerRequest) {
        return new SuccessResponseData((Object)this.customerService.detail(customerRequest));
    }

    @GetResource(name="\u83b7\u53d6\u5217\u8868", path={"/customer/list"})
    public ResponseData<List<Customer>> list(CustomerRequest customerRequest) {
        return new SuccessResponseData(this.customerService.findList(customerRequest));
    }

    @GetResource(name="\u5206\u9875\u67e5\u8be2", path={"/customer/page"})
    public ResponseData<PageResult<Customer>> page(CustomerRequest customerRequest) {
        return new SuccessResponseData(this.customerService.findPage(customerRequest));
    }
}

