/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.api.util;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.exception.DaoException;
import cn.stylefeng.roses.kernel.db.api.exception.enums.DatabaseExceptionEnum;
import cn.stylefeng.roses.kernel.db.api.pojo.db.TableFieldInfo;
import cn.stylefeng.roses.kernel.db.api.pojo.db.TableInfo;
import cn.stylefeng.roses.kernel.db.api.pojo.druid.DruidProperties;
import cn.stylefeng.roses.kernel.db.api.sqladapter.database.CreateDatabaseSql;
import cn.stylefeng.roses.kernel.db.api.sqladapter.database.GetDatabasesSql;
import cn.stylefeng.roses.kernel.db.api.sqladapter.table.TableFieldListSql;
import cn.stylefeng.roses.kernel.db.api.sqladapter.table.TableListSql;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseUtil {
    private static final Logger log = LoggerFactory.getLogger(DatabaseUtil.class);

    public static List<String> getDatabases(DruidProperties druidProperties) {
        ArrayList<String> arrayList;
        Connection conn = null;
        ArrayList<String> databasesList = new ArrayList<String>();
        try {
            Class.forName(druidProperties.getDriverClassName());
            conn = DriverManager.getConnection(druidProperties.getUrl(), druidProperties.getUsername(), druidProperties.getPassword());
            PreparedStatement preparedStatement = conn.prepareStatement(new GetDatabasesSql().getSql(druidProperties.getUrl()));
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String database = resultSet.getString("database");
                if (!StrUtil.isNotBlank((CharSequence)database) || !StrUtil.startWith((CharSequence)database, (CharSequence)"sys_tenant_db_")) continue;
                database = database.replaceAll("sys_tenant_db_", "");
                databasesList.add(database);
            }
            arrayList = databasesList;
        }
        catch (Exception e) {
            try {
                log.error("\u67e5\u8be2\u6240\u6709\u5e93\u9519\u8bef\uff01", (Throwable)e);
                throw new DaoException(DatabaseExceptionEnum.DATABASE_LIST_ERROR, e.getMessage());
            }
            catch (Throwable throwable) {
                IoUtil.close(conn);
                throw throwable;
            }
        }
        IoUtil.close((AutoCloseable)conn);
        return arrayList;
    }

    public static List<TableInfo> selectTables(DruidProperties druidProperties) {
        ArrayList<TableInfo> arrayList;
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        Connection conn = null;
        try {
            Class.forName(druidProperties.getDriverClassName());
            conn = DriverManager.getConnection(druidProperties.getUrl(), druidProperties.getUsername(), druidProperties.getPassword());
            String dbName = DatabaseUtil.getDbName(druidProperties);
            PreparedStatement preparedStatement = conn.prepareStatement(new TableListSql().getSql(druidProperties.getUrl()));
            if (!druidProperties.getUrl().contains("sqlserver") && !druidProperties.getUrl().contains("postgresql")) {
                preparedStatement.setString(1, dbName);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                TableInfo tableInfo = new TableInfo();
                String tableName = resultSet.getString("tableName");
                String tableComment = resultSet.getString("tableComment");
                tableInfo.setTableName(tableName);
                tableInfo.setTableComment(tableComment);
                tables.add(tableInfo);
            }
            arrayList = tables;
        }
        catch (Exception ex) {
            try {
                log.error("\u67e5\u8be2\u6240\u6709\u8868\u9519\u8bef\uff01", (Throwable)ex);
                throw new DaoException(DatabaseExceptionEnum.TABLE_LIST_ERROR, ex.getMessage());
            }
            catch (Throwable throwable) {
                IoUtil.close(conn);
                throw throwable;
            }
        }
        IoUtil.close((AutoCloseable)conn);
        return arrayList;
    }

    public static List<TableFieldInfo> getTableFields(DruidProperties druidProperties, String tableName) {
        ArrayList<TableFieldInfo> arrayList;
        ArrayList<TableFieldInfo> fieldList = new ArrayList<TableFieldInfo>();
        Connection conn = null;
        try {
            Class.forName(druidProperties.getDriverClassName());
            conn = DriverManager.getConnection(druidProperties.getUrl(), druidProperties.getUsername(), druidProperties.getPassword());
            PreparedStatement preparedStatement = conn.prepareStatement(new TableFieldListSql().getSql(druidProperties.getUrl()));
            if (druidProperties.getUrl().contains("oracle")) {
                preparedStatement.setString(1, tableName);
            } else if (druidProperties.getUrl().contains("postgresql")) {
                preparedStatement.setString(1, tableName);
            } else if (druidProperties.getUrl().contains("sqlserver")) {
                preparedStatement.setString(1, tableName);
            } else {
                String dbName = DatabaseUtil.getDbName(druidProperties);
                preparedStatement.setString(1, tableName);
                preparedStatement.setString(2, dbName);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                TableFieldInfo tableFieldInfo = new TableFieldInfo();
                String columnName = resultSet.getString("columnName");
                String columnComment = resultSet.getString("columnComment");
                tableFieldInfo.setColumnName(columnName);
                tableFieldInfo.setColumnComment(columnComment);
                tableFieldInfo.setCamelFieldName(StrUtil.toCamelCase((CharSequence)columnName));
                fieldList.add(tableFieldInfo);
            }
            arrayList = fieldList;
        }
        catch (Exception ex) {
            try {
                log.error("\u67e5\u8be2\u8868\u7684\u6240\u6709\u5b57\u6bb5\u9519\u8bef\uff01", (Throwable)ex);
                throw new DaoException(DatabaseExceptionEnum.FIELD_GET_ERROR, ex.getMessage());
            }
            catch (Throwable throwable) {
                IoUtil.close(conn);
                throw throwable;
            }
        }
        IoUtil.close((AutoCloseable)conn);
        return arrayList;
    }

    public static void createDatabase(DruidProperties druidProperties, String databaseName) {
        Connection conn = null;
        try {
            Class.forName(druidProperties.getDriverClassName());
            conn = DriverManager.getConnection(druidProperties.getUrl(), druidProperties.getUsername(), druidProperties.getPassword());
            String sql = new CreateDatabaseSql().getSql(druidProperties.getUrl());
            sql = sql.replaceAll("\\?", databaseName);
            PreparedStatement preparedStatement = conn.prepareStatement(sql);
            int i = preparedStatement.executeUpdate();
            log.info("\u521b\u5efa\u6570\u636e\u5e93\uff01\u6570\u91cf\uff1a" + i);
        }
        catch (Exception ex) {
            try {
                log.error("\u6267\u884csql\u51fa\u73b0\u95ee\u9898\uff01", (Throwable)ex);
                throw new DaoException(DatabaseExceptionEnum.CREATE_DATABASE_ERROR, ex.getMessage());
            }
            catch (Throwable throwable) {
                IoUtil.close(conn);
                throw throwable;
            }
        }
        IoUtil.close((AutoCloseable)conn);
    }

    private static String getDbName(DruidProperties druidProperties) {
        if (druidProperties.getUrl().contains("oracle")) {
            return druidProperties.getUsername();
        }
        if (druidProperties.getUrl().contains("postgresql")) {
            int first = druidProperties.getUrl().lastIndexOf("/") + 1;
            return druidProperties.getUrl().substring(first);
        }
        if (druidProperties.getUrl().contains("sqlserver")) {
            int first = druidProperties.getUrl().lastIndexOf("=") + 1;
            return druidProperties.getUrl().substring(first);
        }
        String jdbcUrl = druidProperties.getUrl();
        int first = jdbcUrl.lastIndexOf("/") + 1;
        int last = jdbcUrl.indexOf("?");
        return jdbcUrl.substring(first, last);
    }
}

