/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.api.util;

import cn.hutool.core.io.IoUtil;
import cn.stylefeng.roses.kernel.db.api.exception.DaoException;
import cn.stylefeng.roses.kernel.db.api.exception.enums.DatabaseExceptionEnum;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.ScriptUtils;

public class SqlRunUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlRunUtil.class);

    public static void runClassPathSql(String classpathFileName, String driverClassName, String url, String username, String password) {
        Connection conn = null;
        try {
            Class.forName(driverClassName);
            conn = DriverManager.getConnection(url, username, password);
            ClassPathResource classPathResource = new ClassPathResource(classpathFileName);
            EncodedResource encodedResource = new EncodedResource((Resource)classPathResource, "utf-8");
            ScriptUtils.executeSqlScript((Connection)conn, (EncodedResource)encodedResource);
        }
        catch (Exception e) {
            try {
                log.error("\u6267\u884csql\u9519\u8bef\uff01", (Throwable)e);
                throw new DaoException(DatabaseExceptionEnum.SQL_EXEC_ERROR, e.getMessage());
            }
            catch (Throwable throwable) {
                IoUtil.close(conn);
                throw throwable;
            }
        }
        IoUtil.close((AutoCloseable)conn);
    }

    public static void runFileSystemSql(SqlSessionFactory sqlSessionFactory, String sqlPath) {
        Connection conn = null;
        try {
            SqlSession sqlSession = sqlSessionFactory.openSession();
            conn = sqlSession.getConnection();
            FileSystemResource classPathResource = new FileSystemResource(sqlPath);
            EncodedResource encodedResource = new EncodedResource((Resource)classPathResource, "GBK");
            ScriptUtils.executeSqlScript((Connection)conn, (EncodedResource)encodedResource);
        }
        catch (Exception e) {
            try {
                log.error("\u6267\u884csql\u9519\u8bef\uff01", (Throwable)e);
                throw new DaoException(DatabaseExceptionEnum.SQL_EXEC_ERROR, e.getMessage());
            }
            catch (Throwable throwable) {
                IoUtil.close(conn);
                throw throwable;
            }
        }
        IoUtil.close((AutoCloseable)conn);
    }
}

