/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.api.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlUtil.class);

    public static String parse(List<?> list) {
        String str = "";
        if (list != null && list.size() > 0) {
            str = str + "?";
            for (int i = 1; i < list.size(); ++i) {
                str = str + ",?";
            }
        }
        return str;
    }

    public static Map<String, Object> resultSet2Map(ResultSet resultSet) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            ResultSetMetaData metaData = resultSet.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String columnName = metaData.getColumnName(i);
                Object columnValue = resultSet.getObject(i);
                result.put(columnName, columnValue);
            }
            return result;
        }
        catch (SQLException e) {
            log.error("\u8f6c\u5316\u7ed3\u679c\u96c6\u9519\u8bef\uff01", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    public static List<Map<String, Object>> resultSet2ListMap(ResultSet resultSet) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            while (resultSet.next()) {
                Map<String, Object> map = SqlUtil.resultSet2Map(resultSet);
                result.add(map);
            }
            return result;
        }
        catch (SQLException e) {
            log.error("\u8f6c\u5316\u7ed3\u679c\u96c6\u9519\u8bef\uff01", (Throwable)e);
            return result;
        }
    }
}

