/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.db.flyway;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.exception.DaoException;
import cn.stylefeng.roses.kernel.db.api.exception.enums.FlywayExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class FlywayInitListener
implements ApplicationListener<ApplicationContextInitializedEvent>,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(FlywayInitListener.class);
    private static final String FLYWAY_LOCATIONS = "classpath:db/migration";

    public void onApplicationEvent(ApplicationContextInitializedEvent applicationEnvironmentPreparedEvent) {
        ConfigurableEnvironment environment = applicationEnvironmentPreparedEvent.getApplicationContext().getEnvironment();
        String dataSourceUrl = environment.getProperty("spring.datasource.url");
        String dataSourceUsername = environment.getProperty("spring.datasource.username");
        String dataSourcePassword = environment.getProperty("spring.datasource.password");
        String driverClassName = environment.getProperty("spring.datasource.driver-class-name");
        String enabledStr = environment.getProperty("spring.flyway.enabled");
        String locations = environment.getProperty("spring.flyway.locations");
        String baselineOnMigrateStr = environment.getProperty("spring.flyway.baseline-on-migrate");
        String outOfOrderStr = environment.getProperty("spring.flyway.out-of-order");
        boolean enabled = false;
        if (StrUtil.isNotBlank((CharSequence)enabledStr)) {
            enabled = Boolean.parseBoolean(enabledStr);
        }
        if (!enabled) {
            return;
        }
        if (ObjectUtil.hasEmpty((Object[])new Object[]{dataSourceUrl, dataSourceUsername, dataSourcePassword, driverClassName})) {
            throw new DaoException((AbstractExceptionEnum)FlywayExceptionEnum.DB_CONFIG_ERROR);
        }
        boolean baselineOnMigrate = false;
        if (StrUtil.isNotBlank((CharSequence)baselineOnMigrateStr)) {
            baselineOnMigrate = Boolean.parseBoolean(baselineOnMigrateStr);
        }
        if (StrUtil.isBlank((CharSequence)locations)) {
            locations = FLYWAY_LOCATIONS;
        }
        boolean outOfOrder = false;
        if (StrUtil.isNotBlank((CharSequence)outOfOrderStr)) {
            outOfOrder = Boolean.parseBoolean(outOfOrderStr);
        }
        DriverManagerDataSource dmDataSource = null;
        try {
            assert (dataSourceUrl != null);
            dmDataSource = new DriverManagerDataSource();
            dmDataSource.setDriverClassName(driverClassName);
            dmDataSource.setUrl(dataSourceUrl);
            dmDataSource.setUsername(dataSourceUsername);
            dmDataSource.setPassword(dataSourcePassword);
            Flyway flyway = Flyway.configure().dataSource((DataSource)dmDataSource).locations(new String[]{locations}).baselineOnMigrate(baselineOnMigrate).outOfOrder(outOfOrder).load();
            flyway.migrate();
        }
        catch (Exception e) {
            log.error("flyway\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new DaoException((AbstractExceptionEnum)FlywayExceptionEnum.FLYWAY_MIGRATE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

