/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.email.aliyun;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.email.api.MailSenderApi;
import cn.stylefeng.roses.kernel.email.api.exception.MailException;
import cn.stylefeng.roses.kernel.email.api.exception.enums.EmailExceptionEnum;
import cn.stylefeng.roses.kernel.email.api.pojo.SendMailParam;
import cn.stylefeng.roses.kernel.email.api.pojo.aliyun.AliyunMailSenderProperties;
import cn.stylefeng.roses.kernel.email.api.pojo.aliyun.AliyunSendMailParam;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dm.model.v20151123.BatchSendMailRequest;
import com.aliyuncs.dm.model.v20151123.SingleSendMailRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;

public class AliyunMailSender
implements MailSenderApi {
    private final AliyunMailSenderProperties aliyunMailSenderProperties;
    private IAcsClient acsClient;

    public AliyunMailSender(AliyunMailSenderProperties aliyunMailSenderProperties) {
        this.aliyunMailSenderProperties = aliyunMailSenderProperties;
    }

    public void sendMail(SendMailParam sendMailParam) {
    }

    public void sendMailHtml(SendMailParam sendMailParam) {
    }

    public void sendAliyunMail(AliyunSendMailParam aliyunSendMailParam) {
        this.assertSendMailParams(aliyunSendMailParam);
        this.initClient();
        SingleSendMailRequest singleSendRequest = this.createSingleSendRequest(aliyunSendMailParam);
        try {
            this.acsClient.getAcsResponse((AcsRequest)singleSendRequest);
        }
        catch (ClientException e) {
            String userTip = StrUtil.format((CharSequence)EmailExceptionEnum.ALIYUN_MAIL_SEND_ERROR.getUserTip(), (Object[])new Object[]{e.getErrCode()});
            throw new MailException((AbstractExceptionEnum)EmailExceptionEnum.ALIYUN_MAIL_SEND_ERROR, userTip);
        }
    }

    public void sendBatchAliyunMail(AliyunSendMailParam aliyunSendMailParam) {
        this.assertSendMailParams(aliyunSendMailParam);
        this.initClient();
        BatchSendMailRequest batchSendRequest = this.createBatchSendRequest(aliyunSendMailParam);
        try {
            this.acsClient.getAcsResponse((AcsRequest)batchSendRequest);
        }
        catch (ClientException e) {
            String userTip = StrUtil.format((CharSequence)EmailExceptionEnum.ALIYUN_MAIL_SEND_ERROR.getUserTip(), (Object[])new Object[]{e.getErrCode()});
            throw new MailException((AbstractExceptionEnum)EmailExceptionEnum.ALIYUN_MAIL_SEND_ERROR, userTip);
        }
    }

    private IAcsClient initClient() {
        if (this.acsClient != null) {
            return this.acsClient;
        }
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.aliyunMailSenderProperties.getAccessKeyId(), (String)this.aliyunMailSenderProperties.getAccessKeySecret());
        this.acsClient = new DefaultAcsClient((IClientProfile)profile);
        return this.acsClient;
    }

    private SingleSendMailRequest createSingleSendRequest(AliyunSendMailParam aliyunSendMailParam) {
        SingleSendMailRequest request = new SingleSendMailRequest();
        request.setAccountName(this.aliyunMailSenderProperties.getAccountName());
        request.setFromAlias(aliyunSendMailParam.getFromAlias());
        request.setAddressType(Integer.valueOf(1));
        request.setTagName(aliyunSendMailParam.getTagName());
        request.setReplyToAddress(Boolean.valueOf(true));
        request.setToAddress(aliyunSendMailParam.getTo());
        request.setSubject(aliyunSendMailParam.getTitle());
        request.setHtmlBody(aliyunSendMailParam.getContent());
        request.setMethod(MethodType.POST);
        request.setClickTrace("0");
        return request;
    }

    private BatchSendMailRequest createBatchSendRequest(AliyunSendMailParam aliyunSendMailParam) {
        BatchSendMailRequest request = new BatchSendMailRequest();
        request.setAccountName(this.aliyunMailSenderProperties.getAccountName());
        request.setReceiversName(aliyunSendMailParam.getReceiversName());
        request.setTemplateName(aliyunSendMailParam.getTemplateName());
        request.setAddressType(Integer.valueOf(1));
        request.setTagName(aliyunSendMailParam.getTagName());
        request.setMethod(MethodType.POST);
        request.setClickTrace("0");
        return request;
    }

    private void assertSendMailParams(AliyunSendMailParam aliyunSendMailParam) {
        if (aliyunSendMailParam == null) {
            String format = StrUtil.format((CharSequence)EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getUserTip(), (Object[])new Object[]{""});
            throw new MailException(EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getErrorCode(), format);
        }
        if (ObjectUtil.isEmpty((Object)aliyunSendMailParam.getTo())) {
            String format = StrUtil.format((CharSequence)EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getUserTip(), (Object[])new Object[]{"\u6536\u4ef6\u4eba\u90ae\u7bb1"});
            throw new MailException(EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getErrorCode(), format);
        }
        if (ObjectUtil.isEmpty((Object)aliyunSendMailParam.getTitle())) {
            String format = StrUtil.format((CharSequence)EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getUserTip(), (Object[])new Object[]{"\u90ae\u4ef6\u6807\u9898"});
            throw new MailException(EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getErrorCode(), format);
        }
        if (ObjectUtil.isEmpty((Object)aliyunSendMailParam.getContent())) {
            String format = StrUtil.format((CharSequence)EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getUserTip(), (Object[])new Object[]{"\u90ae\u4ef6\u5185\u5bb9"});
            throw new MailException(EmailExceptionEnum.EMAIL_PARAM_EMPTY_ERROR.getErrorCode(), format);
        }
    }
}

