/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.email.starter;

import cn.hutool.extra.mail.MailAccount;
import cn.stylefeng.roses.kernel.email.api.MailSenderApi;
import cn.stylefeng.roses.kernel.email.api.expander.EmailConfigExpander;
import cn.stylefeng.roses.kernel.email.jdk.JavaMailSender;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GunsEmailAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MailSenderApi.class})
    public MailSenderApi mailSenderApi() {
        MailAccount mailAccount = new MailAccount();
        mailAccount.setHost(EmailConfigExpander.getSmtpHost());
        mailAccount.setPort(EmailConfigExpander.getSmtpPort());
        mailAccount.setAuth(EmailConfigExpander.getSmtpAuthEnable().booleanValue());
        mailAccount.setUser(EmailConfigExpander.getSmtpUser());
        mailAccount.setPass(EmailConfigExpander.getSmtpPass());
        mailAccount.setFrom(EmailConfigExpander.getSmtpFrom());
        mailAccount.setStarttlsEnable(EmailConfigExpander.getStartTlsEnable().booleanValue());
        mailAccount.setSslEnable(EmailConfigExpander.getSSLEnable());
        mailAccount.setSocketFactoryPort(EmailConfigExpander.getSocketFactoryPort().intValue());
        mailAccount.setTimeout(EmailConfigExpander.getTimeout().longValue());
        mailAccount.setConnectionTimeout(EmailConfigExpander.getConnectionTimeout().longValue());
        return new JavaMailSender(mailAccount);
    }
}

