/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.api.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.URLUtil;
import cn.stylefeng.roses.kernel.file.api.exception.FileException;
import cn.stylefeng.roses.kernel.file.api.exception.enums.FileExceptionEnum;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUtil {
    private static final Logger log = LoggerFactory.getLogger(DownloadUtil.class);

    public static void download(String fileName, byte[] fileBytes, HttpServletResponse response) {
        try {
            response.reset();
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + URLUtil.encode((String)fileName) + "\"");
            response.addHeader("Content-Length", "" + fileBytes.length);
            response.setContentType("application/octet-stream;charset=UTF-8");
            IoUtil.write((OutputStream)response.getOutputStream(), (boolean)true, (byte[])fileBytes);
        }
        catch (IOException e) {
            throw new FileException(FileExceptionEnum.DOWNLOAD_FILE_ERROR, e.getMessage());
        }
    }

    public static void download(File file, HttpServletResponse response) {
        String fileName;
        byte[] fileBytes = FileUtil.readBytes((File)file);
        try {
            fileName = URLEncoder.encode(file.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new FileException(FileExceptionEnum.DOWNLOAD_FILE_ERROR, e.getMessage());
        }
        DownloadUtil.download(fileName, fileBytes, response);
    }

    public static void renderPreviewFile(HttpServletResponse response, byte[] fileBytes) {
        try {
            response.setContentType("image/png");
            ServletOutputStream outputStream = response.getOutputStream();
            IoUtil.write((OutputStream)outputStream, (boolean)true, (byte[])fileBytes);
        }
        catch (IOException e) {
            throw new FileException(FileExceptionEnum.WRITE_BYTES_ERROR, e.getMessage());
        }
    }
}

