/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.aliyun;

import cn.hutool.core.io.IoUtil;
import cn.stylefeng.roses.kernel.file.api.FileOperatorApi;
import cn.stylefeng.roses.kernel.file.api.enums.BucketAuthEnum;
import cn.stylefeng.roses.kernel.file.api.enums.FileLocationEnum;
import cn.stylefeng.roses.kernel.file.api.exception.FileException;
import cn.stylefeng.roses.kernel.file.api.exception.enums.FileExceptionEnum;
import cn.stylefeng.roses.kernel.file.api.expander.FileConfigExpander;
import cn.stylefeng.roses.kernel.file.api.pojo.props.AliyunOssProperties;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;

public class AliyunFileOperator
implements FileOperatorApi {
    private OSS ossClient;
    private final AliyunOssProperties aliyunOssProperties;

    public AliyunFileOperator(AliyunOssProperties aliyunOssProperties) {
        this.aliyunOssProperties = aliyunOssProperties;
        this.initClient();
    }

    public void initClient() {
        String endpoint = this.aliyunOssProperties.getEndPoint();
        String accessKeyId = this.aliyunOssProperties.getAccessKeyId();
        String accessKeySecret = this.aliyunOssProperties.getAccessKeySecret();
        Boolean httpsFlag = this.aliyunOssProperties.getHttpsFlag();
        ClientBuilderConfiguration clientBuilderConfiguration = new ClientBuilderConfiguration();
        clientBuilderConfiguration.setProtocol(httpsFlag != false ? Protocol.HTTPS : Protocol.HTTP);
        this.ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret, clientBuilderConfiguration);
    }

    public void destroyClient() {
        this.ossClient.shutdown();
    }

    public Object getClient() {
        return this.ossClient;
    }

    public boolean doesBucketExist(String bucketName) {
        try {
            return this.ossClient.doesBucketExist(bucketName);
        }
        catch (ClientException | OSSException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.ALIYUN_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public void setBucketAcl(String bucketName, BucketAuthEnum bucketAuthEnum) {
        try {
            if (bucketAuthEnum.equals((Object)BucketAuthEnum.PRIVATE)) {
                this.ossClient.setBucketAcl(bucketName, CannedAccessControlList.Private);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ)) {
                this.ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ_WRITE)) {
                this.ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicReadWrite);
            }
        }
        catch (ClientException | OSSException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.ALIYUN_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public boolean isExistingFile(String bucketName, String key) {
        try {
            return this.ossClient.doesObjectExist(bucketName, key);
        }
        catch (ClientException | OSSException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.ALIYUN_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public void storageFile(String bucketName, String key, byte[] bytes) {
        try {
            this.ossClient.putObject(bucketName, key, (InputStream)new ByteArrayInputStream(bytes));
        }
        catch (ClientException | OSSException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.ALIYUN_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public void storageFile(String bucketName, String key, InputStream inputStream) {
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, inputStream);
            this.ossClient.putObject(putObjectRequest);
        }
        catch (ClientException | OSSException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.ALIYUN_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public byte[] getFileBytes(String bucketName, String key) {
        byte[] byArray;
        InputStream objectContent = null;
        try {
            OSSObject ossObject = this.ossClient.getObject(bucketName, key);
            objectContent = ossObject.getObjectContent();
            byArray = IoUtil.readBytes((InputStream)objectContent);
        }
        catch (ClientException | OSSException e) {
            try {
                throw new FileException((AbstractExceptionEnum)FileExceptionEnum.ALIYUN_FILE_ERROR, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                IoUtil.close(objectContent);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)objectContent);
        return byArray;
    }

    public void setFileAcl(String bucketName, String key, BucketAuthEnum bucketAuthEnum) {
        try {
            if (bucketAuthEnum.equals((Object)BucketAuthEnum.PRIVATE)) {
                this.ossClient.setObjectAcl(bucketName, key, CannedAccessControlList.Private);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ)) {
                this.ossClient.setObjectAcl(bucketName, key, CannedAccessControlList.PublicRead);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ_WRITE)) {
                this.ossClient.setObjectAcl(bucketName, key, CannedAccessControlList.PublicReadWrite);
            }
        }
        catch (ClientException | OSSException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.ALIYUN_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public void copyFile(String originBucketName, String originFileKey, String newBucketName, String newFileKey) {
        try {
            this.ossClient.copyObject(originBucketName, originFileKey, newBucketName, newFileKey);
        }
        catch (ClientException | OSSException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.ALIYUN_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public String getFileAuthUrl(String bucketName, String key, Long timeoutMillis) {
        try {
            Date expiration = new Date(System.currentTimeMillis() + timeoutMillis);
            URL url = this.ossClient.generatePresignedUrl(bucketName, key, expiration);
            return url.toString();
        }
        catch (ClientException | OSSException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.ALIYUN_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public String getFileUnAuthUrl(String bucketName, String key) {
        return this.getFileAuthUrl(bucketName, key, FileConfigExpander.getDefaultFileTimeoutSeconds() * 1000L);
    }

    public void deleteFile(String bucketName, String key) {
        this.ossClient.deleteObject(bucketName, key);
    }

    public FileLocationEnum getFileLocationEnum() {
        return FileLocationEnum.ALIYUN;
    }
}

