/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.minio;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.file.FileOperatorApi;
import cn.stylefeng.roses.kernel.file.enums.BucketAuthEnum;
import cn.stylefeng.roses.kernel.file.exception.FileException;
import cn.stylefeng.roses.kernel.file.exception.enums.FileExceptionEnum;
import cn.stylefeng.roses.kernel.file.expander.FileConfigExpander;
import cn.stylefeng.roses.kernel.file.pojo.props.MinIoProperties;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import io.minio.MinioClient;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import io.minio.policy.PolicyType;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class MinIoFileOperator
implements FileOperatorApi {
    private final Object LOCK = new Object();
    Map<String, String> contentType = new HashMap<String, String>();
    private MinioClient minioClient;
    private final MinIoProperties minIoProperties;

    public MinIoFileOperator(MinIoProperties minIoProperties) {
        this.minIoProperties = minIoProperties;
        this.initClient();
    }

    public void initClient() {
        String endpoint = this.minIoProperties.getEndpoint();
        String accessKey = this.minIoProperties.getAccessKey();
        String secretKey = this.minIoProperties.getSecretKey();
        try {
            this.minioClient = new MinioClient(endpoint, accessKey, secretKey);
        }
        catch (InvalidEndpointException | InvalidPortException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.MINIO_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public void destroyClient() {
    }

    public Object getClient() {
        return this.minioClient;
    }

    public boolean doesBucketExist(String bucketName) {
        try {
            return this.minioClient.bucketExists(bucketName);
        }
        catch (Exception e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.MINIO_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public void setBucketAcl(String bucketName, BucketAuthEnum bucketAuthEnum) {
        this.setFileAcl(bucketName, "*", bucketAuthEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistingFile(String bucketName, String key) {
        InputStream inputStream;
        block4: {
            boolean bl;
            inputStream = null;
            try {
                inputStream = this.minioClient.getObject(bucketName, key);
                if (inputStream == null) break block4;
                bl = true;
            }
            catch (Exception e) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    IoUtil.close(inputStream);
                    throw throwable;
                }
                IoUtil.close((Closeable)inputStream);
                return bl2;
            }
            IoUtil.close((Closeable)inputStream);
            return bl;
        }
        IoUtil.close((Closeable)inputStream);
        return false;
    }

    public void storageFile(String bucketName, String key, byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            ByteArrayInputStream byteArrayInputStream = IoUtil.toStream((byte[])bytes);
            ByteArrayInputStream tmp = IoUtil.toStream((byte[])bytes);
            String type = FileTypeUtil.getType((InputStream)tmp);
            String fileContentType = this.getFileContentType(String.format("%s%s", ".", type));
            try {
                this.minioClient.putObject(bucketName, key, (InputStream)byteArrayInputStream, (long)bytes.length, fileContentType);
            }
            catch (Exception e) {
                throw new FileException((AbstractExceptionEnum)FileExceptionEnum.MINIO_FILE_ERROR, new Object[]{e.getMessage()});
            }
        }
    }

    public void storageFile(String bucketName, String key, InputStream inputStream) {
        if (inputStream != null) {
            byte[] bytes = IoUtil.readBytes((InputStream)inputStream);
            this.storageFile(bucketName, key, bytes);
        }
    }

    public byte[] getFileBytes(String bucketName, String key) {
        try {
            InputStream inputStream = this.minioClient.getObject(bucketName, key);
            return IoUtil.readBytes((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.MINIO_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public void setFileAcl(String bucketName, String key, BucketAuthEnum bucketAuthEnum) {
        try {
            if (bucketAuthEnum.equals((Object)BucketAuthEnum.PRIVATE)) {
                this.minioClient.setBucketPolicy(bucketName, key, PolicyType.NONE);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ)) {
                this.minioClient.setBucketPolicy(bucketName, key, PolicyType.READ_ONLY);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ_WRITE)) {
                this.minioClient.setBucketPolicy(bucketName, key, PolicyType.READ_WRITE);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.MINIO_WRITE_ONLY)) {
                this.minioClient.setBucketPolicy(bucketName, key, PolicyType.WRITE_ONLY);
            }
        }
        catch (Exception e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.MINIO_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public void copyFile(String originBucketName, String originFileKey, String newBucketName, String newFileKey) {
        try {
            this.minioClient.copyObject(originBucketName, originFileKey, newBucketName, newFileKey);
        }
        catch (Exception e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.MINIO_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public String getFileAuthUrl(String bucketName, String key, Long timeoutMillis) {
        String token = LoginContext.me().getToken();
        String contextPath = HttpServletUtil.getRequest().getContextPath();
        return FileConfigExpander.getServerDeployHost() + contextPath + "/sysFileInfo/private/preview" + "?fileBucket=" + bucketName + "&fileObjectName=" + key + "&token=" + token;
    }

    public void deleteFile(String bucketName, String key) {
        try {
            this.minioClient.removeObject(bucketName, key);
        }
        catch (Exception e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.MINIO_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getFileContentType() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.contentType.size() == 0) {
                this.contentType.put(".bmp", "application/x-bmp");
                this.contentType.put(".gif", "image/gif");
                this.contentType.put(".fax", "image/fax");
                this.contentType.put(".ico", "image/x-icon");
                this.contentType.put(".jfif", "image/jpeg");
                this.contentType.put(".jpe", "image/jpeg");
                this.contentType.put(".jpeg", "image/jpeg");
                this.contentType.put(".jpg", "image/jpeg");
                this.contentType.put(".png", "image/png");
                this.contentType.put(".rp", "image/vnd.rn-realpix");
                this.contentType.put(".tif", "image/tiff");
                this.contentType.put(".tiff", "image/tiff");
                this.contentType.put(".doc", "application/msword");
                this.contentType.put(".ppt", "application/x-ppt");
                this.contentType.put(".pdf", "application/pdf");
                this.contentType.put(".xls", "application/vnd.ms-excel");
                this.contentType.put(".txt", "text/plain");
                this.contentType.put(".java", "java/*");
                this.contentType.put(".html", "text/html");
                this.contentType.put(".avi", "video/avi");
                this.contentType.put(".movie", "video/x-sgi-movie");
                this.contentType.put(".mp4", "video/mpeg4");
                this.contentType.put(".mp3", "audio/mp3");
            }
        }
        return this.contentType;
    }

    private String getFileContentType(String fileSuffix) {
        String contentType = this.getFileContentType().get(fileSuffix);
        if (ObjectUtil.isEmpty((Object)contentType)) {
            return "application/octet-stream";
        }
        return contentType;
    }
}

