/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.qingyun;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IoUtil;
import cn.stylefeng.roses.kernel.file.api.FileOperatorApi;
import cn.stylefeng.roses.kernel.file.api.enums.BucketAuthEnum;
import cn.stylefeng.roses.kernel.file.api.enums.FileLocationEnum;
import cn.stylefeng.roses.kernel.file.api.expander.FileConfigExpander;
import cn.stylefeng.roses.kernel.file.api.pojo.props.QingYunOssProperties;
import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.service.Bucket;
import com.qingstor.sdk.service.QingStor;
import com.qingstor.sdk.service.Types;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QingYunFileOperator
implements FileOperatorApi {
    private static final Logger log = LoggerFactory.getLogger(QingYunFileOperator.class);
    private QingStor qingStor = null;
    private final QingYunOssProperties qingYunOssProperties;

    public QingYunFileOperator(QingYunOssProperties qingYunOssProperties) {
        this.qingYunOssProperties = qingYunOssProperties;
        this.initClient();
    }

    public void initClient() {
        EnvContext env = new EnvContext(this.qingYunOssProperties.getQyAccessKeyId(), this.qingYunOssProperties.getQySecretAccessKey());
        env.setEndpoint(this.qingYunOssProperties.getEndPoint());
        this.qingStor = new QingStor(env);
    }

    public void destroyClient() {
    }

    public Object getClient() {
        return this.qingStor;
    }

    public boolean doesBucketExist(String bucketName) {
        try {
            QingStor.ListBucketsOutput listBucketsOutput = this.qingStor.listBuckets(null);
            List buckets = listBucketsOutput.getBuckets();
            for (Types.BucketModel bucket : buckets) {
                if (!bucket.getName().equals(bucketName)) continue;
                return true;
            }
        }
        catch (QSException e) {
            log.error("\u9752\u4e91\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return false;
    }

    public void setBucketAcl(String bucketName, BucketAuthEnum bucketAuthEnum) {
    }

    public boolean isExistingFile(String bucketName, String key) {
        Bucket bucket = this.qingStor.getBucket(bucketName, this.qingYunOssProperties.getZone());
        Bucket.GetObjectOutput object = null;
        try {
            object = bucket.getObject(key, null);
        }
        catch (QSException e) {
            log.error("\u9752\u4e91\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
            return false;
        }
        return object != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storageFile(String bucketName, String key, byte[] bytes) {
        Bucket bucket = this.qingStor.getBucket(bucketName, this.qingYunOssProperties.getZone());
        Bucket.PutObjectInput input = new Bucket.PutObjectInput();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        input.setBodyInputStream((InputStream)byteArrayInputStream);
        input.setContentLength(Convert.toLong((Object)bytes.length));
        try {
            bucket.putObject(key, input);
        }
        catch (QSException e) {
            log.error("\u9752\u4e91\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            IoUtil.close((Closeable)byteArrayInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storageFile(String bucketName, String key, InputStream inputStream) {
        Bucket bucket = this.qingStor.getBucket(bucketName, this.qingYunOssProperties.getZone());
        Bucket.PutObjectInput input = new Bucket.PutObjectInput();
        input.setBodyInputStream(inputStream);
        try {
            bucket.putObject(key, input);
        }
        catch (QSException e) {
            log.error("\u9752\u4e91\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            IoUtil.close((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFileBytes(String bucketName, String key) {
        byte[] byArray;
        Bucket bucket = this.qingStor.getBucket(bucketName, this.qingYunOssProperties.getZone());
        Bucket.GetObjectOutput object = null;
        InputStream objectContent = null;
        try {
            object = bucket.getObject(key, null);
            objectContent = object.getBodyInputStream();
            byArray = IoUtil.readBytes((InputStream)objectContent);
        }
        catch (QSException e) {
            byte[] byArray2;
            try {
                log.error("\u9752\u4e91\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                IoUtil.close(objectContent);
                throw throwable;
            }
            IoUtil.close((Closeable)objectContent);
            return byArray2;
        }
        IoUtil.close((Closeable)objectContent);
        return byArray;
    }

    public void setFileAcl(String bucketName, String key, BucketAuthEnum bucketAuthEnum) {
    }

    public void copyFile(String originBucketName, String originFileKey, String newBucketName, String newFileKey) {
    }

    public String getFileAuthUrl(String bucketName, String key, Long timeoutMillis) {
        Bucket bucket = this.qingStor.getBucket(bucketName, this.qingYunOssProperties.getZone());
        try {
            return bucket.GetObjectSignatureUrl(key, timeoutMillis / 1000L);
        }
        catch (QSException e) {
            log.error("\u9752\u4e91\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    public String getFileUnAuthUrl(String bucketName, String key) {
        return this.getFileAuthUrl(bucketName, key, FileConfigExpander.getDefaultFileTimeoutSeconds() * 1000L);
    }

    public void deleteFile(String bucketName, String key) {
        Bucket bucket = this.qingStor.getBucket(bucketName, this.qingYunOssProperties.getZone());
        try {
            bucket.deleteObject(key);
        }
        catch (QSException e) {
            log.error("\u9752\u4e91\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public FileLocationEnum getFileLocationEnum() {
        return FileLocationEnum.QING_YUN;
    }
}

