/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.tencent;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ExecutorBuilder;
import cn.stylefeng.roses.kernel.file.api.FileOperatorApi;
import cn.stylefeng.roses.kernel.file.api.enums.BucketAuthEnum;
import cn.stylefeng.roses.kernel.file.api.exception.FileException;
import cn.stylefeng.roses.kernel.file.api.exception.enums.FileExceptionEnum;
import cn.stylefeng.roses.kernel.file.api.expander.FileConfigExpander;
import cn.stylefeng.roses.kernel.file.api.pojo.props.TenCosProperties;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.activation.MimetypesFileTypeMap;

public class TenFileOperator
implements FileOperatorApi {
    private final TenCosProperties tenCosProperties;
    private COSClient cosClient;
    private TransferManager transferManager;

    public TenFileOperator(TenCosProperties tenCosProperties) {
        this.tenCosProperties = tenCosProperties;
        this.initClient();
    }

    public void initClient() {
        String secretId = this.tenCosProperties.getSecretId();
        String secretKey = this.tenCosProperties.getSecretKey();
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        Region region = new Region(this.tenCosProperties.getRegionId());
        ClientConfig clientConfig = new ClientConfig(region);
        this.cosClient = new COSClient((COSCredentials)cred, clientConfig);
        ThreadPoolExecutor threadPool = ExecutorBuilder.create().build();
        this.transferManager = new TransferManager((COS)this.cosClient, (ExecutorService)threadPool);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartUploadThreshold(0xA00000L);
        transferManagerConfiguration.setMinimumUploadPartSize(0xA00000L);
        this.transferManager.setConfiguration(transferManagerConfiguration);
    }

    public void destroyClient() {
        this.cosClient.shutdown();
    }

    public Object getClient() {
        return this.cosClient;
    }

    public boolean doesBucketExist(String bucketName) {
        try {
            return this.cosClient.doesBucketExist(bucketName);
        }
        catch (CosClientException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.TENCENT_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public void setBucketAcl(String bucketName, BucketAuthEnum bucketAuthEnum) {
        try {
            if (bucketAuthEnum.equals((Object)BucketAuthEnum.PRIVATE)) {
                this.cosClient.setBucketAcl(bucketName, CannedAccessControlList.Private);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ)) {
                this.cosClient.setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ_WRITE)) {
                this.cosClient.setBucketAcl(bucketName, CannedAccessControlList.PublicReadWrite);
            }
        }
        catch (CosClientException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.TENCENT_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public boolean isExistingFile(String bucketName, String key) {
        try {
            this.cosClient.getObjectMetadata(bucketName, key);
            return true;
        }
        catch (CosServiceException e) {
            return false;
        }
    }

    public void storageFile(String bucketName, String key, byte[] bytes) {
        String contentType = "application/octet-stream";
        if (key.contains(".")) {
            contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(key);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentType(contentType);
            this.cosClient.putObject(bucketName, key, (InputStream)new ByteArrayInputStream(bytes), objectMetadata);
        }
        catch (CosClientException e) {
            try {
                throw new FileException((AbstractExceptionEnum)FileExceptionEnum.TENCENT_FILE_ERROR, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                IoUtil.close(byteArrayInputStream);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)byteArrayInputStream);
    }

    public void storageFile(String bucketName, String key, InputStream inputStream) {
        String contentType = "application/octet-stream";
        if (key.contains(".")) {
            contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(key);
        }
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentType(contentType);
            this.cosClient.putObject(bucketName, key, inputStream, objectMetadata);
        }
        catch (CosClientException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.TENCENT_FILE_ERROR, new Object[]{e.getMessage()});
        }
        finally {
            IoUtil.close((Closeable)inputStream);
        }
    }

    public byte[] getFileBytes(String bucketName, String key) {
        byte[] byArray;
        COSObjectInputStream cosObjectInput = null;
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
            COSObject cosObject = this.cosClient.getObject(getObjectRequest);
            cosObjectInput = cosObject.getObjectContent();
            byArray = IoUtil.readBytes((InputStream)cosObjectInput);
        }
        catch (CosClientException e) {
            try {
                throw new FileException((AbstractExceptionEnum)FileExceptionEnum.TENCENT_FILE_ERROR, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                IoUtil.close(cosObjectInput);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)cosObjectInput);
        return byArray;
    }

    public void setFileAcl(String bucketName, String key, BucketAuthEnum bucketAuthEnum) {
        if (bucketAuthEnum.equals((Object)BucketAuthEnum.PRIVATE)) {
            this.cosClient.setObjectAcl(bucketName, key, CannedAccessControlList.Private);
        } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ)) {
            this.cosClient.setObjectAcl(bucketName, key, CannedAccessControlList.PublicRead);
        } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ_WRITE)) {
            this.cosClient.setObjectAcl(bucketName, key, CannedAccessControlList.PublicReadWrite);
        }
    }

    public void copyFile(String originBucketName, String originFileKey, String newBucketName, String newFileKey) {
        Region srcBucketRegion = new Region(this.tenCosProperties.getRegionId());
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketRegion, originBucketName, originFileKey, newBucketName, newFileKey);
        try {
            this.transferManager.copy(copyObjectRequest, (COS)this.cosClient, null);
        }
        catch (CosClientException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.TENCENT_FILE_ERROR, new Object[]{e.getMessage()});
        }
    }

    public String getFileAuthUrl(String bucketName, String key, Long timeoutMillis) {
        GeneratePresignedUrlRequest presignedUrlRequest = new GeneratePresignedUrlRequest(bucketName, key, HttpMethodName.GET);
        Date expirationDate = new Date(System.currentTimeMillis() + timeoutMillis);
        presignedUrlRequest.setExpiration(expirationDate);
        URL url = null;
        try {
            url = this.cosClient.generatePresignedUrl(presignedUrlRequest);
        }
        catch (CosClientException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.TENCENT_FILE_ERROR, new Object[]{e.getMessage()});
        }
        return url.toString();
    }

    public String getFileUnAuthUrl(String bucketName, String key) {
        return this.getFileAuthUrl(bucketName, key, FileConfigExpander.getDefaultFileTimeoutSeconds() * 1000L);
    }

    public void deleteFile(String bucketName, String key) {
        this.cosClient.deleteObject(bucketName, key);
    }
}

