/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.i18n.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dict.api.DictApi;
import cn.stylefeng.roses.kernel.i18n.api.context.TranslationContext;
import cn.stylefeng.roses.kernel.i18n.api.exception.TranslationException;
import cn.stylefeng.roses.kernel.i18n.api.exception.enums.TranslationExceptionEnum;
import cn.stylefeng.roses.kernel.i18n.api.pojo.TranslationDict;
import cn.stylefeng.roses.kernel.i18n.api.pojo.request.TranslationRequest;
import cn.stylefeng.roses.kernel.i18n.modular.entity.Translation;
import cn.stylefeng.roses.kernel.i18n.modular.factory.TranslationDictFactory;
import cn.stylefeng.roses.kernel.i18n.modular.mapper.TranslationMapper;
import cn.stylefeng.roses.kernel.i18n.modular.service.TranslationService;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TranslationServiceImpl
extends ServiceImpl<TranslationMapper, Translation>
implements TranslationService {
    @Resource
    private DictApi dictApi;

    @Override
    public void add(TranslationRequest translationRequest) {
        Translation translation = new Translation();
        BeanUtil.copyProperties((Object)translationRequest, (Object)((Object)translation), (String[])new String[0]);
        this.save((Object)translation);
        this.saveContext(translation);
    }

    @Override
    public void edit(TranslationRequest translationRequest) {
        Translation translation = this.queryTranslationById(translationRequest);
        BeanUtil.copyProperties((Object)translationRequest, (Object)((Object)translation), (String[])new String[0]);
        this.updateById((Object)translation);
        this.saveContext(translation);
    }

    @Override
    public void del(TranslationRequest translationRequest) {
        Translation translation = this.queryTranslationById(translationRequest);
        this.removeById(translationRequest.getTranId());
        TranslationContext.me().deleteTranslationDict(translation.getTranLanguageCode(), translation.getTranCode());
    }

    @Override
    public Translation detail(TranslationRequest translationRequest) {
        LambdaQueryWrapper<Translation> queryWrapper = this.createWrapper(translationRequest);
        return (Translation)((Object)this.getOne((Wrapper)queryWrapper, false));
    }

    @Override
    public List<Translation> findList(TranslationRequest translationRequest) {
        LambdaQueryWrapper<Translation> queryWrapper = this.createWrapper(translationRequest);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public PageResult<Translation> findPage(TranslationRequest translationRequest) {
        LambdaQueryWrapper<Translation> wrapper = this.createWrapper(translationRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public void deleteTranLanguage(TranslationRequest translationRequest) {
        this.dictApi.deleteByDictId(translationRequest.getDictId());
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(Translation::getTranLanguageCode, (Object)translationRequest.getTranLanguageCode());
        this.remove((Wrapper)wrapper);
    }

    public List<TranslationDict> getAllTranslationDict() {
        List list = this.list();
        ArrayList<TranslationDict> translationDictList = new ArrayList<TranslationDict>();
        for (Translation translation : list) {
            TranslationDict translationDict = TranslationDictFactory.createTranslationDict(translation.getTranLanguageCode(), translation);
            translationDictList.add(translationDict);
        }
        return translationDictList;
    }

    private Translation queryTranslationById(TranslationRequest translationRequest) {
        Translation translation = (Translation)((Object)this.getById(translationRequest.getTranId()));
        if (ObjectUtil.isEmpty((Object)((Object)translation))) {
            throw new TranslationException((AbstractExceptionEnum)TranslationExceptionEnum.NOT_EXISTED, new Object[]{translationRequest.getTranId()});
        }
        return translation;
    }

    private LambdaQueryWrapper<Translation> createWrapper(TranslationRequest translationRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(Translation::getTranCode);
        if (ObjectUtil.isEmpty((Object)translationRequest)) {
            return queryWrapper;
        }
        Long tranId = translationRequest.getTranId();
        String tranCode = translationRequest.getTranCode();
        String tranName = translationRequest.getTranName();
        String tranLanguageCode = translationRequest.getTranLanguageCode();
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)tranId), Translation::getTranId, (Object)tranId);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)tranCode), Translation::getTranCode, (Object)tranCode);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)tranName), Translation::getTranName, (Object)tranName);
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)tranLanguageCode), Translation::getTranLanguageCode, (Object)tranLanguageCode);
        return queryWrapper;
    }

    private void saveContext(Translation translation) {
        if (translation.getTranLanguageCode() == null) {
            return;
        }
        TranslationDict translationDict = TranslationDictFactory.createTranslationDict(translation.getTranLanguageCode(), translation);
        TranslationContext.me().addTranslationDict(translationDict);
    }
}

