/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.config;

import cn.hutool.core.date.DateUtil;
import cn.stylefeng.roses.core.aop.RequestDataAop;
import cn.stylefeng.roses.core.base.controller.GlobalErrorView;
import cn.stylefeng.roses.core.converter.RequestDataMessageConvert;
import cn.stylefeng.roses.core.util.MvcAdapter;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
@ConditionalOnBean(value={ServletContext.class})
public class WebAutoConfiguration
extends WebMvcConfigurationSupport {
    @Autowired
    private RequestMappingHandlerAdapter handlerAdapter;

    @Bean(value={"error"})
    public GlobalErrorView error() {
        return new GlobalErrorView();
    }

    @Bean
    public RequestDataAop requestDataAop() {
        return new RequestDataAop();
    }

    @Bean
    public RequestMappingHandlerAdapter requestMappingHandlerAdapter(FastJsonHttpMessageConverter fastJsonHttpMessageConverter, RequestDataMessageConvert requestDataMessageConvert) {
        return MvcAdapter.requestMappingHandlerAdapter(super.requestMappingHandlerAdapter(), fastJsonHttpMessageConverter, requestDataMessageConvert);
    }

    @Bean
    public RequestDataMessageConvert requestDataMessageConvert() {
        return new RequestDataMessageConvert();
    }

    @PostConstruct
    public void addConversionConfig() {
        ConfigurableWebBindingInitializer initializer = (ConfigurableWebBindingInitializer)this.handlerAdapter.getWebBindingInitializer();
        if ((initializer != null ? initializer.getConversionService() : null) != null) {
            GenericConversionService genericConversionService = (GenericConversionService)initializer.getConversionService();
            genericConversionService.addConverter((Converter)new StringToDateConverter());
        }
    }

    public class StringToDateConverter
    implements Converter<String, Date> {
        public Date convert(String dateString) {
            return DateUtil.parse((String)dateString);
        }
    }
}

