/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.converter;

import cn.hutool.core.io.IoUtil;
import cn.stylefeng.roses.core.reqres.request.RequestData;
import cn.stylefeng.roses.core.util.HttpContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class RequestDataMessageConvert
extends AbstractGenericHttpMessageConverter<Object> {
    private static final Logger log = LoggerFactory.getLogger(RequestDataMessageConvert.class);

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        if (type instanceof Class) {
            return ((Class)type).isAssignableFrom(RequestData.class);
        }
        return false;
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        if (type instanceof Class) {
            return ((Class)type).isAssignableFrom(RequestData.class);
        }
        return false;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Collections.singletonList(MediaType.ALL);
    }

    protected boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(Map.class);
    }

    public Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.readMap(inputMessage);
    }

    public void writeInternal(Object o, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.readMap(inputMessage);
    }

    private Object readMap(HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String requestBody = IoUtil.read((InputStream)inputMessage.getBody(), (String)"UTF-8");
        if (log.isDebugEnabled()) {
            log.debug("\u63a5\u6536\u5230requestBody: " + requestBody);
        }
        HttpServletRequest request = HttpContext.getRequest();
        return this.getRequestData(requestBody, request);
    }

    private Object getRequestData(String requestBody, HttpServletRequest request) {
        RequestData requestData = new RequestData();
        if (request != null) {
            requestData.setIp(request.getRemoteHost());
            requestData.setUrl(request.getServletPath());
        }
        requestData.setData(this.clearWhiteSpace(requestBody));
        return requestData;
    }

    private JSONObject clearWhiteSpace(String requestBody) {
        JSONObject jsonObject = JSON.parseObject((String)requestBody);
        if (jsonObject != null) {
            Set entries = jsonObject.entrySet();
            for (Map.Entry entry : entries) {
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                value = ((String)value).trim();
                jsonObject.put((String)entry.getKey(), value);
            }
            return jsonObject;
        }
        return null;
    }
}

