/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.feign;

import cn.hutool.core.io.IoUtil;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.model.exception.AbstractBaseExceptionEnum;
import cn.stylefeng.roses.kernel.model.exception.ApiServiceException;
import cn.stylefeng.roses.kernel.model.exception.ServiceException;
import cn.stylefeng.roses.kernel.model.exception.enums.CoreExceptionEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosesFeignErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(RosesFeignErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        ApiServiceException apiServiceExceptionByClassName;
        String resposeBody;
        try {
            if (response == null || response.body() == null) {
                if (response != null && response.status() == 404) {
                    return new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.REMOTE_SERVICE_NULL);
                }
                return new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.SERVICE_ERROR);
            }
            resposeBody = IoUtil.read((InputStream)response.body().asInputStream(), (String)"UTF-8");
        }
        catch (IOException e) {
            return new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.IO_ERROR);
        }
        JSONObject jsonObject = JSON.parseObject((String)resposeBody);
        if (log.isDebugEnabled()) {
            log.debug("FeignErrorDecoder\u6536\u5230\u9519\u8bef\u54cd\u5e94\u7ed3\u679c\uff1a" + resposeBody);
        }
        String exceptionClazz = jsonObject.getString("exceptionClazz");
        Integer code = jsonObject.getInteger("code");
        String message = jsonObject.getString("message");
        if (ToolUtil.isNotEmpty((Object)exceptionClazz) && (apiServiceExceptionByClassName = this.getApiServiceExceptionByClassName(exceptionClazz, code, message)) != null) {
            return apiServiceExceptionByClassName;
        }
        if (message == null) {
            message = CoreExceptionEnum.SERVICE_ERROR.getMessage();
        }
        if (code == null) {
            Integer status = jsonObject.getInteger("status");
            if (status == null) {
                return new ServiceException(CoreExceptionEnum.SERVICE_ERROR.getCode(), message);
            }
            return new ServiceException(status, message);
        }
        return new ServiceException(code, message);
    }

    private ApiServiceException getApiServiceExceptionByClassName(String className, final Integer code, final String message) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(AbstractBaseExceptionEnum.class);
            return (ApiServiceException)constructor.newInstance(new AbstractBaseExceptionEnum(){

                public Integer getCode() {
                    return code;
                }

                public String getMessage() {
                    return message;
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

