/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.core.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.date.DateUtil;
import cn.stylefeng.roses.core.config.properties.AppNameProperties;
import cn.stylefeng.roses.core.util.SpringContextHolder;
import cn.stylefeng.roses.kernel.model.exception.AbstractBaseExceptionEnum;
import cn.stylefeng.roses.kernel.model.exception.ServiceException;
import cn.stylefeng.roses.kernel.model.exception.enums.CoreExceptionEnum;
import cn.stylefeng.roses.kernel.model.util.ValidateUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolUtil
extends ValidateUtil {
    public static final int SALT_LENGTH = 6;

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String md5Hex(String password, String salt) {
        return ToolUtil.md5Hex(password + salt);
    }

    public static String md5Hex(String str) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] bs = md5.digest(str.getBytes());
            StringBuffer md5StrBuff = new StringBuffer();
            for (int i = 0; i < bs.length; ++i) {
                if (Integer.toHexString(0xFF & bs[i]).length() == 1) {
                    md5StrBuff.append("0").append(Integer.toHexString(0xFF & bs[i]));
                    continue;
                }
                md5StrBuff.append(Integer.toHexString(0xFF & bs[i]));
            }
            return md5StrBuff.toString();
        }
        catch (Exception e) {
            throw new ServiceException((AbstractBaseExceptionEnum)CoreExceptionEnum.ENCRYPT_ERROR);
        }
    }

    public static String removeWhiteSpace(String value) {
        if (ToolUtil.isEmpty((Object)value)) {
            return "";
        }
        return value.replaceAll("\\s*", "");
    }

    public static String getCreateTimeBefore(int seconds) {
        long currentTimeInMillis = Calendar.getInstance().getTimeInMillis();
        Date date = new Date(currentTimeInMillis - (long)(seconds * 1000));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static String getExceptionMsg(Throwable e) {
        StringWriter sw = new StringWriter();
        try {
            e.printStackTrace(new PrintWriter(sw));
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return sw.getBuffer().toString().replaceAll("\\$", "T");
    }

    public static String getApplicationName() {
        try {
            AppNameProperties appNameProperties = SpringContextHolder.getBean(AppNameProperties.class);
            if (appNameProperties != null) {
                return appNameProperties.getName();
            }
            return "";
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(ToolUtil.class);
            logger.error("\u83b7\u53d6\u5e94\u7528\u540d\u79f0\u9519\u8bef\uff01", (Throwable)e);
            return "";
        }
    }

    public static String getIP() {
        try {
            StringBuilder IFCONFIG = new StringBuilder();
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                    IFCONFIG.append(inetAddress.getHostAddress().toString() + "\n");
                }
            }
            return IFCONFIG.toString();
        }
        catch (SocketException ex) {
            ex.printStackTrace();
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtil.copyProperties((Object)source, (Object)target, (CopyOptions)CopyOptions.create().setIgnoreNullValue(true).ignoreError());
    }

    public static Boolean isWinOs() {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().startsWith("win")) {
            return true;
        }
        return false;
    }

    public static String getTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static Integer toInt(Object val) {
        if (val instanceof Double) {
            BigDecimal bigDecimal = new BigDecimal((Double)val);
            return bigDecimal.intValue();
        }
        return Integer.valueOf(val.toString());
    }

    public static boolean isNum(Object obj) {
        try {
            Integer.parseInt(obj.toString());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getWebRootPath(String filePath) {
        try {
            String path = ToolUtil.class.getClassLoader().getResource("").toURI().getPath();
            path = path.replace("/WEB-INF/classes/", "");
            path = path.replace("/target/classes/", "");
            path = path.replace("file:/", "");
            if (ToolUtil.isEmpty((Object)filePath)) {
                return path;
            }
            return path + "/" + filePath;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFileSuffix(String fileWholeName) {
        if (ToolUtil.isEmpty((Object)fileWholeName)) {
            return "none";
        }
        int lastIndexOf = fileWholeName.lastIndexOf(".");
        return fileWholeName.substring(lastIndexOf + 1);
    }

    public static String dateType(Object o) {
        if (o instanceof Date) {
            return DateUtil.formatDate((Date)((Date)o));
        }
        return o.toString();
    }

    public static String currentTime() {
        return DateUtil.formatDateTime((Date)new Date());
    }

    public static Map<String, Object> toMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        return BeanUtil.beanToMap((Object)object);
    }

    public static String stringReplaceBuild(String value, Map<String, Object> params) {
        String result = value;
        for (String key : params.keySet()) {
            if (params.get(key) == null) continue;
            result = result.replace("#{" + key + "}", params.get(key).toString());
        }
        return result;
    }
}

