/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.guns.roses.email.core.mail.service;

import cn.stylefeng.guns.roses.email.core.enums.MailSendResultEnum;
import cn.stylefeng.guns.roses.email.core.mail.MailManager;
import cn.stylefeng.guns.roses.email.core.model.SendMailParam;
import cn.stylefeng.roses.kernel.model.exception.AbstractBaseExceptionEnum;
import cn.stylefeng.roses.kernel.model.exception.RequestEmptyException;
import cn.stylefeng.roses.kernel.model.exception.ServiceException;
import cn.stylefeng.roses.kernel.model.util.ValidateUtil;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class JavaMailManager
implements MailManager {
    private static final Logger log = LoggerFactory.getLogger(JavaMailManager.class);
    @Autowired
    private JavaMailSender javaMailSender;
    @Value(value="${mail.from}")
    private String from;

    @Override
    public void sendMail(SendMailParam sendMailParam) {
        this.assertSendMailParams(sendMailParam);
        log.info("\u53c2\u6570\u6821\u9a8c\u6210\u529f\u3002\u3002\u3002\u3002");
        try {
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, true);
            mimeMessageHelper.setFrom(this.from);
            mimeMessageHelper.setTo(sendMailParam.getTo());
            mimeMessageHelper.setSubject(sendMailParam.getTitle());
            mimeMessageHelper.setText(sendMailParam.getContent(), true);
            this.javaMailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new ServiceException((AbstractBaseExceptionEnum)MailSendResultEnum.MAIL_SEND_ERROR);
        }
    }

    private void assertSendMailParams(SendMailParam sendMailParam) {
        if (sendMailParam == null || ValidateUtil.isOneEmpty((Object[])new Object[]{sendMailParam.getTo(), sendMailParam.getTitle(), sendMailParam.getContent()})) {
            throw new RequestEmptyException();
        }
    }
}

