/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.email.spring;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.email.MailSender;
import cn.stylefeng.roses.email.spring.enums.SpringMailSendResultEnum;
import cn.stylefeng.roses.email.spring.exception.SpringMailException;
import cn.stylefeng.roses.email.spring.model.SendMailParam;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class SpringJavaSender
implements MailSender {
    private static final Logger log = LoggerFactory.getLogger(SpringJavaSender.class);
    private final JavaMailSender javaMailSender;
    private final String from;

    public SpringJavaSender(JavaMailSender javaMailSender, String from) {
        this.javaMailSender = javaMailSender;
        this.from = from;
    }

    @Override
    public void sendMail(SendMailParam sendMailParam) {
        this.assertSendMailParams(sendMailParam);
        try {
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, true);
            mimeMessageHelper.setFrom(this.from);
            mimeMessageHelper.setTo(sendMailParam.getTo());
            mimeMessageHelper.setSubject(sendMailParam.getTitle());
            mimeMessageHelper.setText(sendMailParam.getContent(), true);
            this.javaMailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new SpringMailException(SpringMailSendResultEnum.MAIL_SEND_ERROR.getCode(), SpringMailSendResultEnum.MAIL_SEND_ERROR.getMessage());
        }
    }

    private void assertSendMailParams(SendMailParam sendMailParam) {
        if (sendMailParam == null) {
            throw new SpringMailException(400, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)sendMailParam.getTo())) {
            throw new SpringMailException(400, "\u6536\u4ef6\u4eba\u90ae\u7bb1\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)sendMailParam.getTitle())) {
            throw new SpringMailException(400, "\u90ae\u4ef6\u6807\u9898\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)sendMailParam.getContent())) {
            throw new SpringMailException(400, "\u90ae\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
    }
}

