/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.guns.excel.util;

import cn.stylefeng.guns.excel.MergeCellValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jxls.common.Context;
import org.jxls.expression.JexlExpressionEvaluator;
import org.jxls.transform.Transformer;
import org.jxls.transform.poi.WritableCellValue;
import org.jxls.util.JxlsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxlsUtils {
    private static final Logger log = LoggerFactory.getLogger(JxlsUtils.class);

    public static void exportExcel(InputStream inputStream, OutputStream outputStream, Map<String, Object> model) {
        Context context = new Context();
        if (model != null) {
            for (String key : model.keySet()) {
                context.putVar(key, model.get(key));
            }
        }
        JxlsHelper jxlsHelper = JxlsHelper.getInstance();
        Transformer transformer = jxlsHelper.createTransformer(inputStream, outputStream);
        JexlExpressionEvaluator evaluator = (JexlExpressionEvaluator)transformer.getTransformationConfig().getExpressionEvaluator();
        HashMap<String, JxlsUtils> funcs = new HashMap<String, JxlsUtils>();
        funcs.put("utils", new JxlsUtils());
        evaluator.getJexlEngine().setFunctions(funcs);
        try {
            jxlsHelper.setUseFastFormulaProcessor(false).processTemplate(context, transformer);
        }
        catch (IOException e) {
            log.error("\u5bfc\u51faexcel\u8fc7\u7a0b\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    public WritableCellValue mergeCell(String value, Integer mergerRows) {
        return new MergeCellValue(value, mergerRows);
    }
}

