/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.guns.excel.view;

import cn.stylefeng.guns.excel.util.JxlsUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractView;

public class JxlsExcelView
extends AbstractView {
    private static final String CONTENT_TYPE = "application/vnd.ms-excel";
    private String templatePath;
    private String exportFileName;
    private String type = ".xls";

    public JxlsExcelView(String templatePath, String exportFileName, String type) {
        this.templatePath = templatePath;
        this.exportFileName = exportFileName;
        if (type != null && !type.equals("")) {
            this.type = type;
        }
        this.setContentType(CONTENT_TYPE);
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FileInputStream inputStream = null;
        ServletOutputStream outputStream = null;
        outputStream = response.getOutputStream();
        response.setContentType(this.getContentType());
        String filename = new String(this.exportFileName.getBytes("gb2312"), "iso8859-1");
        response.setHeader("content-disposition", "attachment;filename=" + filename + this.type);
        inputStream = new FileInputStream(new File(this.templatePath));
        JxlsUtils.exportExcel(inputStream, (OutputStream)outputStream, model);
        outputStream.flush();
        outputStream.close();
        ((InputStream)inputStream).close();
    }
}

