/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.file.modular.aliyun;

import cn.hutool.core.io.IoUtil;
import cn.stylefeng.roses.file.FileOperator;
import cn.stylefeng.roses.file.common.enums.BucketAuthEnum;
import cn.stylefeng.roses.file.modular.aliyun.exp.AliyunFileServiceException;
import cn.stylefeng.roses.file.modular.aliyun.prop.AliyunOssProperties;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;

public class AliyunFileOperator
implements FileOperator {
    private OSS ossClient;
    private final AliyunOssProperties aliyunOssProperties;

    public AliyunFileOperator(AliyunOssProperties aliyunOssProperties) {
        this.aliyunOssProperties = aliyunOssProperties;
        this.initClient();
    }

    @Override
    public void initClient() {
        String endpoint = this.aliyunOssProperties.getEndPoint();
        String accessKeyId = this.aliyunOssProperties.getAccessKeyId();
        String accessKeySecret = this.aliyunOssProperties.getAccessKeySecret();
        this.ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
    }

    @Override
    public void destroyClient() {
        this.ossClient.shutdown();
    }

    @Override
    public Object getClient() {
        return this.ossClient;
    }

    @Override
    public boolean doesBucketExist(String bucketName) {
        try {
            return this.ossClient.doesBucketExist(bucketName);
        }
        catch (OSSException e) {
            throw new AliyunFileServiceException(e);
        }
        catch (ClientException e) {
            throw new AliyunFileServiceException(e);
        }
    }

    @Override
    public void setBucketAcl(String bucketName, BucketAuthEnum bucketAuthEnum) {
        try {
            if (bucketAuthEnum.equals((Object)BucketAuthEnum.PRIVATE)) {
                this.ossClient.setBucketAcl(bucketName, CannedAccessControlList.Private);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ)) {
                this.ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ_WRITE)) {
                this.ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicReadWrite);
            }
        }
        catch (OSSException e) {
            throw new AliyunFileServiceException(e);
        }
        catch (ClientException e) {
            throw new AliyunFileServiceException(e);
        }
    }

    @Override
    public boolean isExistingFile(String bucketName, String key) {
        try {
            return this.ossClient.doesObjectExist(bucketName, key);
        }
        catch (OSSException e) {
            throw new AliyunFileServiceException(e);
        }
        catch (ClientException e) {
            throw new AliyunFileServiceException(e);
        }
    }

    @Override
    public void storageFile(String bucketName, String key, byte[] bytes) {
        try {
            this.ossClient.putObject(bucketName, key, (InputStream)new ByteArrayInputStream(bytes));
        }
        catch (OSSException e) {
            throw new AliyunFileServiceException(e);
        }
        catch (ClientException e) {
            throw new AliyunFileServiceException(e);
        }
    }

    @Override
    public void storageFile(String bucketName, String key, InputStream inputStream) {
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, inputStream);
            this.ossClient.putObject(putObjectRequest);
        }
        catch (OSSException e) {
            throw new AliyunFileServiceException(e);
        }
        catch (ClientException e) {
            throw new AliyunFileServiceException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getFileBytes(String bucketName, String key) {
        byte[] byArray;
        InputStream objectContent = null;
        try {
            OSSObject ossObject = this.ossClient.getObject(bucketName, key);
            objectContent = ossObject.getObjectContent();
            byArray = IoUtil.readBytes((InputStream)objectContent);
        }
        catch (OSSException e) {
            try {
                throw new AliyunFileServiceException(e);
                catch (ClientException e2) {
                    throw new AliyunFileServiceException(e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.close(objectContent);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)objectContent);
        return byArray;
    }

    @Override
    public void setFileAcl(String bucketName, String key, BucketAuthEnum bucketAuthEnum) {
        try {
            if (bucketAuthEnum.equals((Object)BucketAuthEnum.PRIVATE)) {
                this.ossClient.setObjectAcl(bucketName, key, CannedAccessControlList.Private);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ)) {
                this.ossClient.setObjectAcl(bucketName, key, CannedAccessControlList.PublicRead);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ_WRITE)) {
                this.ossClient.setObjectAcl(bucketName, key, CannedAccessControlList.PublicReadWrite);
            }
        }
        catch (OSSException e) {
            throw new AliyunFileServiceException(e);
        }
        catch (ClientException e) {
            throw new AliyunFileServiceException(e);
        }
    }

    @Override
    public void copyFile(String originBucketName, String originFileKey, String newBucketName, String newFileKey) {
        try {
            this.ossClient.copyObject(originBucketName, originFileKey, newBucketName, newFileKey);
        }
        catch (OSSException e) {
            throw new AliyunFileServiceException(e);
        }
        catch (ClientException e) {
            throw new AliyunFileServiceException(e);
        }
    }

    @Override
    public String getFileAuthUrl(String bucketName, String key, Long timeoutMillis) {
        try {
            Date expiration = new Date(new Date().getTime() + timeoutMillis);
            URL url = this.ossClient.generatePresignedUrl(bucketName, key, expiration);
            return url.toString();
        }
        catch (OSSException e) {
            throw new AliyunFileServiceException(e);
        }
        catch (ClientException e) {
            throw new AliyunFileServiceException(e);
        }
    }
}

