/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.file.modular.tencent;

import cn.hutool.core.io.IoUtil;
import cn.stylefeng.roses.file.FileOperator;
import cn.stylefeng.roses.file.common.enums.BucketAuthEnum;
import cn.stylefeng.roses.file.modular.tencent.exp.TencentFileServiceException;
import cn.stylefeng.roses.file.modular.tencent.prop.TenCosProperties;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.activation.MimetypesFileTypeMap;

public class TenFileOperator
implements FileOperator {
    private final TenCosProperties tenCosProperties;
    private COSClient cosClient;
    private TransferManager transferManager;

    public TenFileOperator(TenCosProperties tenCosProperties) {
        this.tenCosProperties = tenCosProperties;
        this.initClient();
    }

    @Override
    public void initClient() {
        String secretId = this.tenCosProperties.getSecretId();
        String secretKey = this.tenCosProperties.getSecretKey();
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        Region region = new Region(this.tenCosProperties.getRegionId());
        ClientConfig clientConfig = new ClientConfig(region);
        this.cosClient = new COSClient((COSCredentials)cred, clientConfig);
        ExecutorService threadPool = Executors.newFixedThreadPool(32);
        this.transferManager = new TransferManager((COS)this.cosClient, threadPool);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartUploadThreshold(0xA00000L);
        transferManagerConfiguration.setMinimumUploadPartSize(0xA00000L);
        this.transferManager.setConfiguration(transferManagerConfiguration);
    }

    @Override
    public void destroyClient() {
        this.cosClient.shutdown();
    }

    @Override
    public Object getClient() {
        return this.cosClient;
    }

    @Override
    public boolean doesBucketExist(String bucketName) {
        try {
            return this.cosClient.doesBucketExist(bucketName);
        }
        catch (CosServiceException e) {
            throw new TencentFileServiceException(e);
        }
        catch (CosClientException e) {
            throw new TencentFileServiceException(e);
        }
    }

    @Override
    public void setBucketAcl(String bucketName, BucketAuthEnum bucketAuthEnum) {
        try {
            if (bucketAuthEnum.equals((Object)BucketAuthEnum.PRIVATE)) {
                this.cosClient.setBucketAcl(bucketName, CannedAccessControlList.Private);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ)) {
                this.cosClient.setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
            } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ_WRITE)) {
                this.cosClient.setBucketAcl(bucketName, CannedAccessControlList.PublicReadWrite);
            }
        }
        catch (CosServiceException e) {
            throw new TencentFileServiceException(e);
        }
        catch (CosClientException e) {
            throw new TencentFileServiceException(e);
        }
    }

    @Override
    public boolean isExistingFile(String bucketName, String key) {
        try {
            this.cosClient.getObjectMetadata(bucketName, key);
            return true;
        }
        catch (CosServiceException e) {
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void storageFile(String bucketName, String key, byte[] bytes) {
        String contentType = "application/octet-stream";
        if (key.contains(".")) {
            contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(key);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentType(contentType);
            this.cosClient.putObject(bucketName, key, (InputStream)new ByteArrayInputStream(bytes), objectMetadata);
        }
        catch (CosServiceException e) {
            try {
                throw new TencentFileServiceException(e);
                catch (CosClientException e2) {
                    throw new TencentFileServiceException(e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.close(byteArrayInputStream);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)byteArrayInputStream);
    }

    @Override
    public void storageFile(String bucketName, String key, InputStream inputStream) {
        String contentType = "application/octet-stream";
        if (key.contains(".")) {
            contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(key);
        }
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentType(contentType);
            this.cosClient.putObject(bucketName, key, inputStream, objectMetadata);
        }
        catch (CosServiceException e) {
            throw new TencentFileServiceException(e);
        }
        catch (CosClientException e) {
            throw new TencentFileServiceException(e);
        }
        finally {
            IoUtil.close((Closeable)inputStream);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getFileBytes(String bucketName, String key) {
        byte[] byArray;
        COSObjectInputStream cosObjectInput = null;
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
            COSObject cosObject = this.cosClient.getObject(getObjectRequest);
            cosObjectInput = cosObject.getObjectContent();
            byArray = IoUtil.readBytes((InputStream)cosObjectInput);
        }
        catch (CosServiceException e) {
            try {
                throw new TencentFileServiceException(e);
                catch (CosClientException e2) {
                    throw new TencentFileServiceException(e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.close(cosObjectInput);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)cosObjectInput);
        return byArray;
    }

    @Override
    public void setFileAcl(String bucketName, String key, BucketAuthEnum bucketAuthEnum) {
        if (bucketAuthEnum.equals((Object)BucketAuthEnum.PRIVATE)) {
            this.cosClient.setObjectAcl(bucketName, key, CannedAccessControlList.Private);
        } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ)) {
            this.cosClient.setObjectAcl(bucketName, key, CannedAccessControlList.PublicRead);
        } else if (bucketAuthEnum.equals((Object)BucketAuthEnum.PUBLIC_READ_WRITE)) {
            this.cosClient.setObjectAcl(bucketName, key, CannedAccessControlList.PublicReadWrite);
        }
    }

    @Override
    public void copyFile(String originBucketName, String originFileKey, String newBucketName, String newFileKey) {
        Region srcBucketRegion = new Region(this.tenCosProperties.getRegionId());
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketRegion, originBucketName, originFileKey, newBucketName, newFileKey);
        try {
            this.transferManager.copy(copyObjectRequest, (COS)this.cosClient, null);
        }
        catch (CosServiceException e) {
            throw new TencentFileServiceException(e);
        }
        catch (CosClientException e) {
            throw new TencentFileServiceException(e);
        }
    }

    @Override
    public String getFileAuthUrl(String bucketName, String key, Long timeoutMillis) {
        GeneratePresignedUrlRequest presignedUrlRequest = new GeneratePresignedUrlRequest(bucketName, key, HttpMethodName.GET);
        Date expirationDate = new Date(System.currentTimeMillis() + timeoutMillis);
        presignedUrlRequest.setExpiration(expirationDate);
        URL url = null;
        try {
            url = this.cosClient.generatePresignedUrl(presignedUrlRequest);
        }
        catch (CosServiceException e) {
            throw new TencentFileServiceException(e);
        }
        catch (CosClientException e) {
            throw new TencentFileServiceException(e);
        }
        return url.toString();
    }
}

