/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.file.modular.local;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import cn.stylefeng.roses.file.FileOperator;
import cn.stylefeng.roses.file.common.enums.BucketAuthEnum;
import cn.stylefeng.roses.file.common.exp.FileServiceException;
import cn.stylefeng.roses.file.modular.local.prop.LocalFileProperties;
import java.io.File;
import java.io.InputStream;

public class LocalFileOperator
implements FileOperator {
    private final LocalFileProperties localFileProperties;
    private String currentSavePath = "";

    public LocalFileOperator(LocalFileProperties localFileProperties) {
        this.localFileProperties = localFileProperties;
        this.initClient();
    }

    @Override
    public void initClient() {
        if (SystemUtil.getOsInfo().isWindows()) {
            String savePathWindows = this.localFileProperties.getLocalFileSavePathWin();
            if (!FileUtil.exist((String)savePathWindows)) {
                FileUtil.mkdir((String)savePathWindows);
            }
            this.currentSavePath = savePathWindows;
        } else {
            String savePathLinux = this.localFileProperties.getLocalFileSavePathLinux();
            if (!FileUtil.exist((String)savePathLinux)) {
                FileUtil.mkdir((String)savePathLinux);
            }
            this.currentSavePath = savePathLinux;
        }
    }

    @Override
    public void destroyClient() {
    }

    @Override
    public Object getClient() {
        return null;
    }

    @Override
    public boolean doesBucketExist(String bucketName) {
        String absolutePath = this.currentSavePath + File.separator + bucketName;
        return FileUtil.exist((String)absolutePath);
    }

    @Override
    public void setBucketAcl(String bucketName, BucketAuthEnum bucketAuthEnum) {
    }

    @Override
    public boolean isExistingFile(String bucketName, String key) {
        String absoluteFile = this.currentSavePath + File.separator + bucketName + File.separator + key;
        return FileUtil.exist((String)absoluteFile);
    }

    @Override
    public void storageFile(String bucketName, String key, byte[] bytes) {
        String bucketPath = this.currentSavePath + File.separator + bucketName;
        if (!FileUtil.exist((String)bucketPath)) {
            FileUtil.mkdir((String)bucketPath);
        }
        String absoluteFile = this.currentSavePath + File.separator + bucketName + File.separator + key;
        FileUtil.writeBytes((byte[])bytes, (String)absoluteFile);
    }

    @Override
    public void storageFile(String bucketName, String key, InputStream inputStream) {
        String bucketPath = this.currentSavePath + File.separator + bucketName;
        if (!FileUtil.exist((String)bucketPath)) {
            FileUtil.mkdir((String)bucketPath);
        }
        String absoluteFile = this.currentSavePath + File.separator + bucketName + File.separator + key;
        FileUtil.writeFromStream((InputStream)inputStream, (String)absoluteFile);
    }

    @Override
    public byte[] getFileBytes(String bucketName, String key) {
        String absoluteFile = this.currentSavePath + File.separator + bucketName + File.separator + key;
        if (!FileUtil.exist((String)absoluteFile)) {
            String message = StrUtil.format((CharSequence)"\u6587\u4ef6\u4e0d\u5b58\u5728,bucket={},key={}", (Object[])new Object[]{bucketName, key});
            throw new FileServiceException(message);
        }
        return FileUtil.readBytes((String)absoluteFile);
    }

    @Override
    public void setFileAcl(String bucketName, String key, BucketAuthEnum bucketAuthEnum) {
    }

    @Override
    public void copyFile(String originBucketName, String originFileKey, String newBucketName, String newFileKey) {
        String originFile = this.currentSavePath + File.separator + originBucketName + File.separator + originFileKey;
        if (!FileUtil.exist((String)originFile)) {
            String message = StrUtil.format((CharSequence)"\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728,bucket={},key={}", (Object[])new Object[]{originBucketName, originFileKey});
            throw new FileServiceException(message);
        }
        String destFile = this.currentSavePath + File.separator + newBucketName + File.separator + newFileKey;
        FileUtil.copy((String)originFile, (String)destFile, (boolean)true);
    }

    @Override
    public String getFileAuthUrl(String bucketName, String key, Long timeoutMillis) {
        return null;
    }

    @Override
    public void deleteFile(String bucketName, String key) {
        String file = this.currentSavePath + File.separator + bucketName + File.separator + key;
        if (!FileUtil.exist((String)file)) {
            return;
        }
        FileUtil.del((String)file);
    }
}

