package cn.stylefeng.roses.groovy.core.data;

import cn.stylefeng.roses.core.mutidatasource.annotion.DataSource;
import cn.stylefeng.roses.core.util.SpringContextHolder;
import cn.stylefeng.roses.groovy.core.data.service.DataSourceService;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;

/**
 * sql操作工具
 *
 * @author fengshuonan
 * @Date 2019/12/29 16:37
 */
@Slf4j
public class SqlExecute {

    /**
     * 获取一条数据
     *
     * @param sql        被执行的sql
     * @param dataSource 数据源名称，可为null
     * @author fengshuonan
     * @Date 2019/12/29 16:37
     */
    public static Map<String, Object> selectOne(String sql, String dataSource) {
        changeDsAnnotation(dataSource, DataSourceService.class, "selectOne", String.class);
        DataSourceService dataSourceService = SpringContextHolder.getBean(DataSourceService.class);
        return dataSourceService.selectOne(sql);
    }

    /**
     * 查询多条记录
     *
     * @param sql        被执行的sql
     * @param dataSource 数据源名称，可为null
     * @author fengshuonan
     * @Date 2019/12/29 16:37
     */
    public static List<Map<String, Object>> selectList(String sql, String dataSource) {
        changeDsAnnotation(dataSource, DataSourceService.class, "selectList", String.class);
        DataSourceService dataSourceService = SpringContextHolder.getBean(DataSourceService.class);
        return dataSourceService.selectList(sql);
    }

    /**
     * 更新数据
     *
     * @param sql        被执行的sql
     * @param dataSource 数据源名称，可为null
     * @author fengshuonan
     * @Date 2019/12/29 16:37
     */
    public static int update(String sql, String dataSource) {
        changeDsAnnotation(dataSource, DataSourceService.class, "update", String.class);
        DataSourceService dataSourceService = SpringContextHolder.getBean(DataSourceService.class);
        return dataSourceService.update(sql);
    }

    /**
     * 新增数据
     *
     * @param sql        被执行的sql
     * @param dataSource 数据源名称，可为null
     * @author fengshuonan
     * @Date 2019/12/29 16:37
     */
    public static int insert(String sql, String dataSource) {
        changeDsAnnotation(dataSource, DataSourceService.class, "insert", String.class);
        DataSourceService dataSourceService = SpringContextHolder.getBean(DataSourceService.class);
        return dataSourceService.insert(sql);
    }

    /**
     * 查询多条记录
     *
     * @param sql        被执行的sql
     * @param dataSource 数据源名称，可为null
     * @author fengshuonan
     * @Date 2019/12/29 16:37
     */
    public static int delete(String sql, String dataSource) {
        changeDsAnnotation(dataSource, DataSourceService.class, "delete", String.class);
        DataSourceService dataSourceService = SpringContextHolder.getBean(DataSourceService.class);
        return dataSourceService.delete(sql);
    }

    /**
     * 通过修改方法上的注解来修改数据源
     *
     * @param clazz          类的类型
     * @param methodName     方法名
     * @param dataSource     需要修改为的数据源名称
     * @param parameterTypes 参数类型
     * @author fengshuonan
     * @Date 2019/12/29 16:39
     */
    private static void changeDsAnnotation(String dataSource,
                                           Class<?> clazz,
                                           String methodName,
                                           Class<?>... parameterTypes) {
        try {
            // 通过反射机制获取方法
            Method method = clazz.getMethod(methodName, parameterTypes);

            // 获取DataSource注解
            DataSource annotation = method.getAnnotation(DataSource.class);

            if (annotation != null) {

                // 修改name的值为参数传来的数据源名称
                InvocationHandler ih = Proxy.getInvocationHandler(annotation);
                Field memberValuesField = ih.getClass().getDeclaredField("memberValues");
                memberValuesField.setAccessible(true);
                Map<String, Object> memberValues = (Map<String, Object>) memberValuesField.get(ih);
                memberValues.put("name", dataSource == null ? "" : dataSource);
            }
        } catch (Exception e) {
            log.error("反射修改DataSource注解值失败！", e);
        }
    }

}
