package cn.stylefeng.roses.groovy.core.data.mapper;

import java.util.List;
import java.util.Map;

/**
 * @author fengshuonan
 * @Date 2019/12/29 15:59
 */
public interface DataSourceMapper {

    /**
     * 查询一条记录
     *
     * @author fengshuonan
     * @Date 2019/12/29 16:02
     */
    Map<String, Object> selectOne(String sql);

    /**
     * 获取许多行数据
     *
     * @author fengshuonan
     * @Date 2019/12/29 16:02
     */
    List<Map<String, Object>> selectList(String sql);

    /**
     * 修改数据
     *
     * @author fengshuonan
     * @Date 2019/12/29 16:02
     */
    int update(String sql);

    /**
     * 新增数据
     *
     * @author fengshuonan
     * @Date 2019/12/29 16:02
     */
    int insert(String sql);

    /**
     * 删除数据
     *
     * @author fengshuonan
     * @Date 2019/12/29 16:02
     */
    int delete(String sql);

}
