package cn.stylefeng.roses.groovy.core.data.service;

import cn.stylefeng.roses.core.mutidatasource.annotion.DataSource;
import cn.stylefeng.roses.groovy.core.data.mapper.DataSourceMapper;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;

public class DataSourceService {

    @Autowired
    private DataSourceMapper dataSourceMapper;

    @DataSource(name = "")
    public Map<String, Object> selectOne(String sql) {
        return dataSourceMapper.selectOne(sql);
    }

    @DataSource(name = "")
    public List<Map<String, Object>> selectList(String sql) {
        return dataSourceMapper.selectList(sql);
    }

    @DataSource(name = "")
    public int update(String sql) {
        return dataSourceMapper.update(sql);
    }

    @DataSource(name = "")
    public int insert(String sql) {
        return dataSourceMapper.insert(sql);
    }

    @DataSource(name = "")
    public int delete(String sql) {
        return dataSourceMapper.delete(sql);
    }

}
