package cn.stylefeng.roses.groovy.core.util;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Method;

/**
 * 动态执行工具类
 *
 * @author fengshuonan
 * @Date 2019/12/29 16:24
 */
@Slf4j
public class GroovyUtil {

    /**
     * 将groovyText转换成class
     *
     * @author fengshuonan
     * @Date 2019/12/29 16:24
     */
    public static Class<?> textToClass(String groovyText) {
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader();
        return (Class<?>) groovyClassLoader.parseClass(groovyText);
    }

    /**
     * 执行java语句
     *
     * @author fengshuonan
     * @Date 2019/12/29 16:24
     */
    public static Object executeShell(String groovyText) {
        GroovyShell shell = new GroovyShell();
        return shell.evaluate(groovyText);
    }

    /**
     * 将groovyText转换成class，并执行某个方法
     *
     * @author fengshuonan
     * @Date 2019/12/29 16:24
     */
    public static Object executeClassMethod(String groovyText, String method, Class<?>[] parameterTypes, Object[] args) {
        try {
            Class<?> clazz = GroovyUtil.textToClass(groovyText);
            Method clazzMethod = clazz.getMethod(method, parameterTypes);
            Object obj = clazz.newInstance();
            return clazzMethod.invoke(obj, args);
        } catch (Exception e) {
            log.error("执行groovy类中方法出错！", e);
            return null;
        }
    }

}
