/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.groovy.core.data;

import cn.stylefeng.roses.core.mutidatasource.annotion.DataSource;
import cn.stylefeng.roses.core.util.SpringContextHolder;
import cn.stylefeng.roses.groovy.core.data.service.DataSourceService;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlExecute {
    private static final Logger log = LoggerFactory.getLogger(SqlExecute.class);

    public static Map<String, Object> selectOne(String sql, String dataSource) {
        SqlExecute.changeDsAnnotation(dataSource, DataSourceService.class, "selectOne", String.class);
        DataSourceService dataSourceService = (DataSourceService)SpringContextHolder.getBean(DataSourceService.class);
        return dataSourceService.selectOne(sql);
    }

    public static List<Map<String, Object>> selectList(String sql, String dataSource) {
        SqlExecute.changeDsAnnotation(dataSource, DataSourceService.class, "selectList", String.class);
        DataSourceService dataSourceService = (DataSourceService)SpringContextHolder.getBean(DataSourceService.class);
        return dataSourceService.selectList(sql);
    }

    public static int update(String sql, String dataSource) {
        SqlExecute.changeDsAnnotation(dataSource, DataSourceService.class, "update", String.class);
        DataSourceService dataSourceService = (DataSourceService)SpringContextHolder.getBean(DataSourceService.class);
        return dataSourceService.update(sql);
    }

    public static int insert(String sql, String dataSource) {
        SqlExecute.changeDsAnnotation(dataSource, DataSourceService.class, "insert", String.class);
        DataSourceService dataSourceService = (DataSourceService)SpringContextHolder.getBean(DataSourceService.class);
        return dataSourceService.insert(sql);
    }

    public static int delete(String sql, String dataSource) {
        SqlExecute.changeDsAnnotation(dataSource, DataSourceService.class, "delete", String.class);
        DataSourceService dataSourceService = (DataSourceService)SpringContextHolder.getBean(DataSourceService.class);
        return dataSourceService.delete(sql);
    }

    private static void changeDsAnnotation(String dataSource, Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(methodName, parameterTypes);
            DataSource annotation = method.getAnnotation(DataSource.class);
            if (annotation != null) {
                InvocationHandler ih = Proxy.getInvocationHandler(annotation);
                Field memberValuesField = ih.getClass().getDeclaredField("memberValues");
                memberValuesField.setAccessible(true);
                Map memberValues = (Map)memberValuesField.get(ih);
                memberValues.put("name", dataSource == null ? "" : dataSource);
            }
        }
        catch (Exception e) {
            log.error("\u53cd\u5c04\u4fee\u6539DataSource\u6ce8\u89e3\u503c\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

