/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.logger.chain.aop;

import cn.stylefeng.roses.core.context.RequestNoContext;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.logger.chain.context.ParentSpanIdHolder;
import cn.stylefeng.roses.kernel.logger.chain.context.SpanIdContext;
import cn.stylefeng.roses.kernel.logger.chain.context.SpanIdHolder;
import cn.stylefeng.roses.kernel.logger.chain.context.TraceIdHolder;
import cn.stylefeng.roses.kernel.logger.chain.enums.RpcPhaseEnum;
import cn.stylefeng.roses.kernel.logger.sql.log.SqlHolder;
import cn.stylefeng.roses.kernel.logger.util.TraceUtil;
import cn.stylefeng.roses.kernel.model.auth.context.LoginUserHolder;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=600)
public class ChainOnControllerAop {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="execution(* *..controller.*.*(..))")
    public void cutService() {
    }

    @Around(value="cutService()")
    public Object sessionKit(ProceedingJoinPoint point) throws Throwable {
        MethodSignature methodSignature = null;
        Signature signature = point.getSignature();
        if (signature instanceof MethodSignature) {
            methodSignature = (MethodSignature)signature;
        }
        long begin = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5f00\u59cb\u8bb0\u5f55controller aop\u8017\u65f6\uff01");
        }
        String currentSpanId = IdWorker.getIdStr();
        SpanIdHolder.set(currentSpanId);
        String parentSpanId = SpanIdContext.getSpanIdByHttpHeader();
        ParentSpanIdHolder.set(parentSpanId);
        String traceId = RequestNoContext.getRequestNoByHttpHeader();
        TraceIdHolder.set(traceId);
        SqlHolder.init();
        LoginUserHolder.init();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("controller aop \u83b7\u53d6\u53c2\u6570\uff01" + (System.currentTimeMillis() - begin));
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("controller aop \u5f00\u59cb\u6267\u884c\u63a7\u5236\u5668\u4e4b\u524d\uff01" + (System.currentTimeMillis() - begin));
            }
            Object result = point.proceed();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("controller aop \u6267\u884c\u63a7\u5236\u5668\u6210\u529f\u5b8c\u6210\uff01" + (System.currentTimeMillis() - begin));
            }
            Object object = result;
            return object;
        }
        catch (Throwable exception) {
            String exceptionMsg = ToolUtil.getExceptionMsg((Throwable)exception);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("controller aop \u8bb0\u5f55\u5b8c\u9519\u8bef\u65e5\u5fd7\uff01" + (System.currentTimeMillis() - begin));
            }
            TraceUtil.trace(methodSignature, RpcPhaseEnum.EP1, traceId, currentSpanId, parentSpanId, exceptionMsg);
            TraceUtil.trace(methodSignature, RpcPhaseEnum.EP1, traceId, currentSpanId, parentSpanId, SqlHolder.getSqlInfoStrings());
            throw exception;
        }
        finally {
            SpanIdHolder.remove();
            ParentSpanIdHolder.remove();
            TraceIdHolder.remove();
            SqlHolder.cleanTempSqlInfos();
            LoginUserHolder.remove();
        }
    }
}

