/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.logger.service.impl;

import cn.stylefeng.roses.kernel.logger.entity.SendingCommonLog;
import cn.stylefeng.roses.kernel.logger.entity.SendingTCLog;
import cn.stylefeng.roses.kernel.logger.entity.SendingTraceLog;
import cn.stylefeng.roses.kernel.logger.service.LogProducerService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;

public class LogProducerServiceImpl
implements LogProducerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ExecutorService executorService = Executors.newFixedThreadPool(10);
    @Autowired
    private KafkaTemplate<String, Object> template;

    @Override
    public void sendMsg(SendingCommonLog log) {
        this.executorService.execute(() -> {
            try {
                this.template.send("_LOG_TOPIC", (Object)"_LOG_TOPIC_KEY", (Object)log);
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u666e\u901a\u65e5\u5fd7\u5230kafka\u9519\u8bef!", (Throwable)e);
            }
        });
    }

    @Override
    public void sendTraceMsg(SendingTraceLog sendingTraceLog) {
        this.executorService.execute(() -> {
            try {
                this.template.send("_TRACE_LOG_TOPIC", (Object)"_TRACE_LOG_TOPIC_KEY", (Object)sendingTraceLog);
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55trace\u65e5\u5fd7\u5230kafka\u9519\u8bef!", (Throwable)e);
            }
        });
    }

    @Override
    public void sendTcMsg(SendingTCLog sendingTCLog) {
        this.executorService.execute(() -> {
            try {
                this.template.send("_TC_LOG_TOPIC", (Object)"_TC_LOG_TOPIC_KEY", (Object)sendingTCLog);
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55trace\u65e5\u5fd7\u5230kafka\u9519\u8bef!", (Throwable)e);
            }
        });
    }
}

