/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.logger.chain.aop;

import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.logger.chain.context.ParentSpanIdHolder;
import cn.stylefeng.roses.kernel.logger.chain.context.SpanIdHolder;
import cn.stylefeng.roses.kernel.logger.chain.context.TraceIdHolder;
import cn.stylefeng.roses.kernel.logger.chain.enums.RpcPhaseEnum;
import cn.stylefeng.roses.kernel.logger.util.TraceUtil;
import cn.stylefeng.roses.kernel.model.request.AbstractBaseRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=620)
public class ChainOnConsumerAop {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="execution(* *..api.*+.*(..))")
    public void cutService() {
    }

    @Around(value="cutService()")
    public Object sessionKit(ProceedingJoinPoint point) throws Throwable {
        MethodSignature methodSignature = null;
        Signature signature = point.getSignature();
        if (signature != null && signature instanceof MethodSignature) {
            methodSignature = (MethodSignature)signature;
        }
        long begin = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5f00\u59cb\u8bb0\u5f55consumer aop\u8017\u65f6\uff01");
        }
        String currentSpanId = SpanIdHolder.get();
        String parentSpanId = ParentSpanIdHolder.get();
        String traceId = TraceIdHolder.get();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("consumer aop \u83b7\u53d6\u53c2\u6570\uff01" + (System.currentTimeMillis() - begin));
        }
        try {
            TraceUtil.trace(methodSignature, RpcPhaseEnum.P2, traceId, currentSpanId, parentSpanId);
            this.setRequestParam(point);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("consumer aop \u5f00\u59cb\u8c03\u7528\u8fdc\u7a0b\u670d\u52a1\u524d\uff01" + (System.currentTimeMillis() - begin));
            }
            Object result = point.proceed();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("consumer aop \u8c03\u7528\u5b8c\u8fdc\u7a0b\u670d\u52a1\uff01" + (System.currentTimeMillis() - begin));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("consumer aop \u53d1\u9001\u8c03\u7528\u6210\u529f\uff01" + (System.currentTimeMillis() - begin));
            }
            return result;
        }
        catch (Throwable exception) {
            String exceptionMsg = ToolUtil.getExceptionMsg((Throwable)exception);
            TraceUtil.trace(methodSignature, RpcPhaseEnum.EP2, traceId, currentSpanId, parentSpanId, exceptionMsg);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("consumer aop \u8bb0\u5f55\u5b8c\u9519\u8bef\u65e5\u5fd7\uff01" + (System.currentTimeMillis() - begin));
            }
            throw exception;
        }
    }

    private void setRequestParam(ProceedingJoinPoint point) {
        Object[] params;
        for (Object param : params = point.getArgs()) {
            if (!(param instanceof AbstractBaseRequest)) continue;
            AbstractBaseRequest abstractBaseRequest = (AbstractBaseRequest)param;
            abstractBaseRequest.setRequestNo(TraceIdHolder.get());
            abstractBaseRequest.setSpanId(SpanIdHolder.get());
        }
    }
}

