/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.logger.util;

import cn.stylefeng.roses.core.context.RequestDataHolder;
import cn.stylefeng.roses.core.request.RequestData;
import cn.stylefeng.roses.core.util.SpringContextHolder;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.logger.chain.context.TraceIdHolder;
import cn.stylefeng.roses.kernel.logger.config.properties.LogProperties;
import cn.stylefeng.roses.kernel.logger.entity.SendingCommonLog;
import cn.stylefeng.roses.kernel.logger.service.LogProducerService;
import cn.stylefeng.roses.kernel.model.auth.AbstractLoginUser;
import cn.stylefeng.roses.kernel.model.auth.context.AbstractLoginContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private static LogProducerService getLogProducer() {
        return (LogProducerService)SpringContextHolder.getBean(LogProducerService.class);
    }

    private static LogProperties getLogProperties() {
        return (LogProperties)SpringContextHolder.getBean(LogProperties.class);
    }

    public static void info(String message) {
        LogUtil.doLog(LogLevel.INFO, RequestDataHolder.get(), message, null);
    }

    public static void error(String message, Throwable exception) {
        LogUtil.doLog(LogLevel.ERROR, RequestDataHolder.get(), message, exception);
    }

    public static void debug(String message) {
        LogUtil.doLog(LogLevel.DEBUG, RequestDataHolder.get(), message, null);
    }

    public static void trace(String message) {
        LogUtil.doLog(LogLevel.TRACE, RequestDataHolder.get(), message, null);
    }

    public static void warn(String message) {
        LogUtil.doLog(LogLevel.WARN, RequestDataHolder.get(), message, null);
    }

    public static void debug(String requestNo, String message) {
        LogUtil.doLog(requestNo, LogLevel.DEBUG, RequestDataHolder.get(), message, null);
    }

    public static void info(String requestNo, String message) {
        LogUtil.doLog(requestNo, LogLevel.INFO, RequestDataHolder.get(), message, null);
    }

    private static void doLog(LogLevel level, RequestData requestData, String message, Throwable exception) {
        LogUtil.doLog(TraceIdHolder.get(), level, requestData, message, exception);
    }

    private static void doLog(String requestNo, LogLevel level, RequestData requestData, String message, Throwable exception) {
        block16: {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            String className = null;
            String methodName = null;
            if (stack.length < 5) {
                className = LogUtil.class.getName();
            } else {
                className = stack[4].getClassName();
                methodName = stack[4].getMethodName();
            }
            try {
                SendingCommonLog log;
                block17: {
                    Logger logger = LoggerFactory.getLogger(Class.forName(className));
                    switch (level) {
                        case INFO: {
                            logger.info(LogUtil.createMessage(requestData, message));
                            break;
                        }
                        case WARN: {
                            logger.warn(LogUtil.createMessage(requestData, message));
                            break;
                        }
                        case DEBUG: {
                            logger.debug(LogUtil.createMessage(requestData, message));
                            break;
                        }
                        case ERROR: {
                            logger.error(LogUtil.createMessage(requestData, message), exception);
                            break;
                        }
                        case TRACE: {
                            logger.trace(LogUtil.createMessage(requestData, message));
                            break;
                        }
                        default: {
                            logger.debug(LogUtil.createMessage(requestData, message));
                        }
                    }
                    if (!LogUtil.isWriteLog(level)) break block16;
                    log = new SendingCommonLog();
                    if (requestData != null) {
                        if (requestData.getData() != null) {
                            log.setRequestData(requestData.getData().toJSONString());
                        }
                        log.setIp(ToolUtil.getIP());
                        log.setUrl(requestData.getUrl());
                    }
                    try {
                        AbstractLoginContext bean = (AbstractLoginContext)SpringContextHolder.getBean(AbstractLoginContext.class);
                        AbstractLoginUser loginUser = bean.getLoginUser();
                        log.setAppCode(loginUser.getAppId().toString());
                        log.setAccountId(loginUser.getUserUniqueId() != null ? loginUser.getUserUniqueId().toString() : null);
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block17;
                        logger.debug("\u5f53\u524d\u6ca1\u6709\u767b\u5f55\u7528\u6237\uff01");
                    }
                }
                log.setRequestNo(requestNo);
                log.setClassName(className);
                log.setMethodName(methodName == null ? "" : methodName);
                log.setLevel(level.name());
                log.setLogContent(message);
                log.setCreateTimestamp(System.currentTimeMillis());
                log.setAppCode(ToolUtil.getApplicationName());
                if (level.equals((Object)LogLevel.ERROR) && exception != null) {
                    log.setLogContent(LogUtil.getErrorInfoFromException(exception));
                }
                LogUtil.getLogProducer().sendMsg(log);
            }
            catch (ClassNotFoundException e) {
                Logger logger = LoggerFactory.getLogger(LogUtil.class);
                logger.error("\u8bb0\u5f55\u65e5\u5fd7\u51fa\u9519,\u627e\u4e0d\u5230\u8c03\u7528\u7c7b\u540d\u79f0!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getErrorInfoFromException(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            e.printStackTrace(pw);
            String string = sw.getBuffer().toString().replaceAll("\\$", "T");
            return string;
        }
        catch (Exception e2) {
            String string = "ErrorInfoFromException";
            return string;
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            pw.close();
        }
    }

    private static boolean isWriteLog(LogLevel level) {
        String levelName;
        LogProperties logProperties = LogUtil.getLogProperties();
        if (!logProperties.getKafka().booleanValue()) {
            return false;
        }
        String logLevelPropertes = logProperties.getLevel();
        if (ToolUtil.isEmpty((Object)logLevelPropertes)) {
            logLevelPropertes = "info,error";
        }
        return (logLevelPropertes = logLevelPropertes.toUpperCase()).contains(levelName = level.name());
    }

    private static String createMessage(RequestData requestData, String message) {
        String requestNo = TraceIdHolder.get();
        return "RequestNo: " + requestNo + " ==>> Messages: " + message + " ==>> RequestData: " + requestData;
    }

    public static enum LogLevel {
        INFO,
        ERROR,
        WARN,
        DEBUG,
        TRACE;

    }
}

