/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.logger.util;

import cn.stylefeng.roses.core.util.HttpContext;
import cn.stylefeng.roses.core.util.SpringContextHolder;
import cn.stylefeng.roses.core.util.ToolUtil;
import cn.stylefeng.roses.kernel.logger.chain.enums.RpcPhaseEnum;
import cn.stylefeng.roses.kernel.logger.config.properties.LogProperties;
import cn.stylefeng.roses.kernel.logger.entity.SendingTCLog;
import cn.stylefeng.roses.kernel.logger.entity.SendingTraceLog;
import cn.stylefeng.roses.kernel.logger.service.LogProducerService;
import cn.stylefeng.roses.kernel.logger.util.LogUtil;
import java.util.Date;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceUtil {
    private static Logger logger = LoggerFactory.getLogger(LogUtil.class);

    public static void trace(MethodSignature methodSignature, RpcPhaseEnum rpcPhaseEnum, String traceId, String spanId, String parentSpanId) {
        TraceUtil.trace(methodSignature, rpcPhaseEnum, traceId, spanId, parentSpanId, "");
    }

    public static void trace(MethodSignature methodSignature, RpcPhaseEnum rpcPhaseEnum, String traceId, String spanId, String parentSpanId, String errorMessage) {
        if (TraceUtil.isTraceFlag()) {
            String servletPath = "";
            try {
                servletPath = HttpContext.getRequest().getServletPath();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            SendingTraceLog sendingTraceLog = new SendingTraceLog();
            sendingTraceLog.setAppCode(ToolUtil.getApplicationName());
            sendingTraceLog.setCreateTimestamp(System.currentTimeMillis());
            sendingTraceLog.setParentSpanId(parentSpanId);
            sendingTraceLog.setSpanId(spanId);
            sendingTraceLog.setRpcPhase(rpcPhaseEnum.name());
            sendingTraceLog.setServletPath(servletPath);
            sendingTraceLog.setTraceId(traceId);
            sendingTraceLog.setContent(errorMessage);
            try {
                TraceUtil.getLogProducer().sendTraceMsg(sendingTraceLog);
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001trace\u6d88\u606f\u9519\u8bef\uff01", (Throwable)e);
            }
        }
    }

    public static void trace(String requestPath, Long useTime) {
        if (TraceUtil.isTraceFlag()) {
            SendingTCLog sendingTCLog = new SendingTCLog();
            sendingTCLog.setCreateTime(new Date());
            sendingTCLog.setRequestPath(requestPath);
            sendingTCLog.setUseTime(useTime);
            try {
                TraceUtil.getLogProducer().sendTcMsg(sendingTCLog);
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001trace tc\u6d88\u606f\u9519\u8bef\uff01", (Throwable)e);
            }
        }
    }

    private static LogProducerService getLogProducer() {
        return (LogProducerService)SpringContextHolder.getBean(LogProducerService.class);
    }

    private static LogProperties getLogProperties() {
        return (LogProperties)SpringContextHolder.getBean(LogProperties.class);
    }

    private static boolean isTraceFlag() {
        try {
            LogProperties logProperties = TraceUtil.getLogProperties();
            return logProperties.getTrace() != false;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6trace\uff01", (Throwable)e);
            return false;
        }
    }
}

