/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.modular;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.model.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.scanner.config.properties.ScannerProperties;
import cn.stylefeng.roses.kernel.scanner.modular.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.modular.annotation.PostResource;
import cn.stylefeng.roses.kernel.scanner.modular.factory.ApiResourceFactory;
import cn.stylefeng.roses.kernel.scanner.modular.stereotype.ApiResource;
import cn.stylefeng.roses.kernel.scanner.modular.util.AopTargetUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

public class ApiResourceScaner
implements BeanPostProcessor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ApiResourceFactory apiResourceFactory;
    private ScannerProperties scannerProperties;
    private String springApplicationName;

    public ApiResourceScaner(ApiResourceFactory apiResourceFactory, ScannerProperties scannerProperties, String springApplicationName) {
        this.apiResourceFactory = apiResourceFactory;
        this.scannerProperties = scannerProperties;
        this.springApplicationName = springApplicationName;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz;
        boolean controllerFlag;
        Object aopTarget = AopTargetUtils.getTarget(bean);
        if (aopTarget == null) {
            aopTarget = bean;
        }
        if (!(controllerFlag = this.getControllerFlag(clazz = aopTarget.getClass()))) {
            return bean;
        }
        List<ResourceDefinition> apiResources = this.doScan(clazz);
        this.persistApiResources(apiResources);
        return bean;
    }

    private boolean getControllerFlag(Class<?> clazz) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = clazz.getAnnotations()) {
            if (!RestController.class.equals(annotation.annotationType()) && !Controller.class.equals(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private List<ResourceDefinition> doScan(Class<?> clazz) {
        ApiResource classApiAnnotation = clazz.getAnnotation(ApiResource.class);
        if (classApiAnnotation != null) {
            if (StrUtil.isEmpty((CharSequence)classApiAnnotation.code())) {
                String className = clazz.getSimpleName();
                int controllerIndex = className.indexOf("Controller");
                if (controllerIndex == -1) {
                    throw new IllegalArgumentException("controller class name is not illegal, it should end with Controller!");
                }
                String code = className.substring(0, controllerIndex);
                this.apiResourceFactory.bindResourceName(StrUtil.toUnderlineCase((CharSequence)code), classApiAnnotation.name());
            } else {
                this.apiResourceFactory.bindResourceName(StrUtil.toUnderlineCase((CharSequence)classApiAnnotation.code()), classApiAnnotation.name());
            }
        }
        ArrayList<ResourceDefinition> apiResources = new ArrayList<ResourceDefinition>();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        if (declaredMethods != null && declaredMethods.length > 0) {
            for (Method declaredMethod : declaredMethods) {
                ApiResource apiResource = declaredMethod.getAnnotation(ApiResource.class);
                GetResource getResource = declaredMethod.getAnnotation(GetResource.class);
                PostResource postResource = declaredMethod.getAnnotation(PostResource.class);
                Annotation annotation = null;
                if (apiResource != null) {
                    annotation = apiResource;
                }
                if (getResource != null) {
                    annotation = getResource;
                }
                if (postResource != null) {
                    annotation = postResource;
                }
                if (annotation == null) continue;
                ResourceDefinition definition = this.createDefinition(clazz, declaredMethod, annotation);
                apiResources.add(definition);
                this.log.debug("\u626b\u63cf\u5230\u8d44\u6e90: " + definition);
            }
        }
        return apiResources;
    }

    private void persistApiResources(List<ResourceDefinition> apiResources) {
        this.apiResourceFactory.registerDefinition(apiResources);
    }

    private ResourceDefinition createDefinition(Class<?> clazz, Method method, Annotation apiResource) {
        ResourceDefinition resourceDefinition = new ResourceDefinition();
        resourceDefinition.setClassName(clazz.getSimpleName());
        resourceDefinition.setMethodName(method.getName());
        String className = resourceDefinition.getClassName();
        int controllerIndex = className.indexOf("Controller");
        if (controllerIndex == -1) {
            throw new IllegalArgumentException("controller class name is not illegal, it should end with Controller!");
        }
        String modular = className.substring(0, controllerIndex);
        resourceDefinition.setModularCode(modular);
        ApiResource classApiAnnotation = clazz.getAnnotation(ApiResource.class);
        resourceDefinition.setModularName(classApiAnnotation.name());
        if (StrUtil.isNotBlank((CharSequence)classApiAnnotation.appCode())) {
            resourceDefinition.setAppCode(classApiAnnotation.appCode());
        } else {
            resourceDefinition.setAppCode(this.scannerProperties.getAppCode());
        }
        String code = this.invokeAnnotationMethod(apiResource, "code", String.class);
        if (StrUtil.isEmpty((CharSequence)code)) {
            resourceDefinition.setCode(resourceDefinition.getAppCode() + this.scannerProperties.getLinkSymbol() + StrUtil.toUnderlineCase((CharSequence)modular) + this.scannerProperties.getLinkSymbol() + StrUtil.toUnderlineCase((CharSequence)method.getName()));
        } else {
            resourceDefinition.setCode(resourceDefinition.getAppCode() + this.scannerProperties.getLinkSymbol() + StrUtil.toUnderlineCase((CharSequence)modular) + this.scannerProperties.getLinkSymbol() + StrUtil.toUnderlineCase((CharSequence)code));
        }
        String name = this.invokeAnnotationMethod(apiResource, "name", String.class);
        String[] path = this.invokeAnnotationMethod(apiResource, "path", String[].class);
        RequestMethod[] requestMethods = this.invokeAnnotationMethod(apiResource, "method", RequestMethod[].class);
        Boolean menuFlag = this.invokeAnnotationMethod(apiResource, "menuFlag", Boolean.class);
        Boolean requiredLogin = this.invokeAnnotationMethod(apiResource, "requiredLogin", Boolean.class);
        Boolean requiredPermission = this.invokeAnnotationMethod(apiResource, "requiredPermission", Boolean.class);
        resourceDefinition.setRequiredLogin(requiredLogin);
        resourceDefinition.setRequiredPermission(requiredPermission);
        resourceDefinition.setMenuFlag(menuFlag);
        resourceDefinition.setName(name);
        resourceDefinition.setUrl(this.getControllerClassRequestPath(clazz) + path[0]);
        String methodNames = "";
        for (RequestMethod requestMethod : requestMethods) {
            methodNames = methodNames + requestMethod.name() + ",";
        }
        resourceDefinition.setHttpMethod(StrUtil.removeSuffix((CharSequence)methodNames, (CharSequence)","));
        String localMacAddress = null;
        try {
            localMacAddress = NetUtil.getLocalhostStr();
        }
        catch (UtilException e) {
            this.log.error("\u83b7\u53d6\u5f53\u524d\u673a\u5668ip\u5730\u5740\u9519\u8bef\uff01");
        }
        resourceDefinition.setIpAddress(localMacAddress == null ? "" : localMacAddress);
        resourceDefinition.setCreateTime(new Date());
        return resourceDefinition;
    }

    private String getControllerClassRequestPath(Class<?> clazz) {
        String[] paths;
        ApiResource controllerRequestMapping = clazz.getDeclaredAnnotation(ApiResource.class);
        String result = controllerRequestMapping == null ? "" : ((paths = controllerRequestMapping.path()).length > 0 ? paths[0] : "");
        result = "/" + this.springApplicationName + result;
        return result;
    }

    private <T> T invokeAnnotationMethod(Annotation apiResource, String methodName, Class<T> resultType) {
        try {
            Class<? extends Annotation> annotationType = apiResource.annotationType();
            Method method = annotationType.getMethod(methodName, new Class[0]);
            return (T)method.invoke((Object)apiResource, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.log.error("\u626b\u63cfapi\u8d44\u6e90\u65f6\u51fa\u9519!", (Throwable)e);
            throw new RuntimeException("\u626b\u63cfapi\u8d44\u6e90\u65f6\u51fa\u9519!");
        }
    }
}

